/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.stream.CustomDataBean;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

public abstract class CustomDataMapper
extends BambooStAXMappingListHelperAbstractImpl<CustomDataBean, CustomDataBean> {
    private static final Logger log = LogManager.getLogger(CustomDataMapper.class);
    static final String CUSTOMDATA_KEY = "key";
    static final String CUSTOMDATA_VALUE = "value";

    protected CustomDataMapper(SessionFactory sessionFactory, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, transactionOperations);
    }

    @Override
    @NotNull
    protected CustomDataBean createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new CustomDataBean();
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull CustomDataBean entry, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        new SMOutputElementAppender(outputElement).append(CUSTOMDATA_KEY, entry.getKey()).append(CUSTOMDATA_VALUE, entry.getValue());
    }

    @Override
    protected void importProperties(@NotNull CustomDataBean entry, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        String elementName = inputCursor.getLocalName();
        if (CUSTOMDATA_KEY.equals(elementName)) {
            entry.setKey(inputCursor.getElemStringValue());
        } else if (CUSTOMDATA_VALUE.equals(elementName)) {
            entry.setValue(inputCursor.getElemStringValue());
        }
    }

    public void exportMapXml(@NotNull SMOutputElement outputElement, @NotNull Map<String, String> customDataMap, ExportDetailsBean exportDetailsBean) throws Exception {
        this.exportListXml(outputElement, customDataMap.entrySet().stream().map(CustomDataBean.fromMapEntry).collect(Collectors.toSet()), exportDetailsBean);
    }

    public Map<String, String> importMapXml(@NotNull SMInputCursor inputCursor) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        for (CustomDataBean customDataBean : this.importListXml(inputCursor)) {
            map.put(customDataBean.getKey(), customDataBean.getValue());
        }
        return map;
    }
}

