/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.aws.ec2.EC2InstanceType;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.aws.ec2.model.AvailabilityZoneId;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfigurationAccessor;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfigurationImpl;
import com.atlassian.bamboo.agent.elastic.server.ElasticInstanceManager;
import com.atlassian.bamboo.core.Script;
import com.atlassian.bamboo.core.ScriptImpl;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.dao.ScriptDao;
import com.atlassian.bamboo.migration.stream.CapabilitySetMapper;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySetManager;
import com.atlassian.bamboo.v2.build.agent.capability.ImageCapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.ImageCapabilitySetImpl;
import com.atlassian.core.bean.EntityObject;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.ReplicationMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ListMapper(rootNodeName="images", itemNodeName="image")
public class ElasticImageConfigurationMapper
extends BambooStAXMappingListHelperAbstractImpl<ElasticImageConfiguration, ElasticImageConfiguration>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(ElasticImageConfigurationMapper.class);
    private static final String IMAGE_CONFIGURATION_AMI_ID = "awsId";
    private static final String IMAGE_CONFIGURATION_ROOT_FS_SIZE_OVERRIDE = "rootFsSizeOverride";
    private static final String IMAGE_CONFIGURATION_CAPABILITIES = "capabilities";
    private static final String IMAGE_CONFIGURATION_NAME = "configurationName";
    private static final String IMAGE_CONFIGURATION_DESCRIPTION = "configurationDescription";
    private static final String IMAGE_CONFIGURATION_EBS_SNAPSHOT_ID = "ebsSnapshotId";
    private static final String IMAGE_CONFIGURATION_INSTANCE_TYPE = "instanceType";
    private static final String IMAGE_CONFIGURATION_AVAILABILITY_ZONE = "availabilityZone";
    private static final String IMAGE_CONFIGURATION_SHIPPED_WITH_BAMBOO = "shippedWithBamboo";
    private static final String IMAGE_CONFIGURATION_PRODUCT = "product";
    private static final String IMAGE_CONFIGURATION_REGION = "region";
    private static final String IMAGE_CONFIGURATION_ROOT_DEVICE_TYPE = "rootDeviceType";
    private static final String IMAGE_CONFIGURATION_ARCHITECTURE = "architecture";
    private static final String IMAGE_CONFIGURATION_PLATFORM = "platform";
    private static final String IMAGE_CONFIGURATION_SUBNET = "subnet";
    private static final String IMAGE_CONFIGURATION_SCRIPT_IDS = "scriptIds";
    private static final String IMAGE_CONFIGURATION_IMAGE_DISABLED = "disabled";
    private static final String IMAGE_CONFIGURATION_LEGACY_EBS_HANDLING = "legacyEbsHandling";
    private static final String IMAGE_CONFIGURATION_IMAGE_FILES_VERSION = "imageFilesVersion";
    private static final String IMAGE_CONFIGURATION_OS_NAME = "osName";
    private static final String IMAGE_CONFIGURATION_VIRTUALIZATION_TYPE = "virtualizationType";
    private static final String IMAGE_CONFIGURATION_PER_SECOND_BILLING = "perSecondBilling";
    private final CapabilitySetMapper capabilityMapper;
    private final ElasticImageConfigurationAccessor elasticImageConfigurationAccessor;
    private final CapabilitySetManager capabilitySetManager;
    private final ScriptDao scriptDao;

    public ElasticImageConfigurationMapper(SessionFactory sessionFactory, CapabilitySetManager capabilitySetManager, ScriptDao scriptDao, ElasticImageConfigurationAccessor elasticImageConfigurationAccessor, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, transactionOperations);
        this.capabilitySetManager = capabilitySetManager;
        this.elasticImageConfigurationAccessor = elasticImageConfigurationAccessor;
        this.capabilityMapper = new CapabilitySetMapper(sessionFactory, transactionOperations);
        this.scriptDao = scriptDao;
    }

    @Override
    @NotNull
    protected ElasticImageConfigurationImpl createItemInstance(SMInputCursor inputCursor) throws Exception {
        ElasticImageConfigurationImpl imageConfiguration = new ElasticImageConfigurationImpl();
        imageConfiguration.setInstanceType(ElasticInstanceManager.DEFAULT_INSTANCE_TYPE_32);
        return imageConfiguration;
    }

    @Override
    protected void importProperties(@NotNull ElasticImageConfiguration object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(object, inputCursor, session);
        if (object instanceof ElasticImageConfigurationImpl) {
            ElasticImageConfigurationImpl elasticImageConfiguration = (ElasticImageConfigurationImpl)object;
            String elementLocalName = inputCursor.getLocalName();
            if (IMAGE_CONFIGURATION_AMI_ID.equals(elementLocalName)) {
                elasticImageConfiguration.setAmiId(inputCursor.getElemStringValue());
            } else if (IMAGE_CONFIGURATION_NAME.equals(elementLocalName)) {
                elasticImageConfiguration.setConfigurationName(inputCursor.getElemStringValue());
            } else if (IMAGE_CONFIGURATION_DESCRIPTION.equals(elementLocalName)) {
                elasticImageConfiguration.setConfigurationDescription(inputCursor.getElemStringValue());
            } else if (IMAGE_CONFIGURATION_EBS_SNAPSHOT_ID.equals(elementLocalName)) {
                elasticImageConfiguration.setEbsSnapshotId(inputCursor.getElemStringValue());
            } else if (IMAGE_CONFIGURATION_INSTANCE_TYPE.equals(elementLocalName)) {
                elasticImageConfiguration.setInstanceType((EC2InstanceType)inputCursor.getElemEnumValue(EC2InstanceType.class));
            } else if (IMAGE_CONFIGURATION_AVAILABILITY_ZONE.equals(elementLocalName)) {
                elasticImageConfiguration.setAvailabilityZones(ElasticImageConfigurationMapper.toAzs(inputCursor.getElemStringValue()));
            } else if (IMAGE_CONFIGURATION_SHIPPED_WITH_BAMBOO.equals(elementLocalName)) {
                elasticImageConfiguration.setShippedWithBamboo(inputCursor.getElemBooleanValue());
            } else if (IMAGE_CONFIGURATION_PRODUCT.equals(elementLocalName)) {
                elasticImageConfiguration.setProduct(inputCursor.getElemStringValue());
            } else if (IMAGE_CONFIGURATION_REGION.equals(elementLocalName)) {
                elasticImageConfiguration.setRegion((AwsSupportConstants.Region)inputCursor.getElemEnumValue(AwsSupportConstants.Region.class));
            } else if (IMAGE_CONFIGURATION_ROOT_DEVICE_TYPE.equals(elementLocalName)) {
                elasticImageConfiguration.setRootDeviceType((AwsSupportConstants.RootDeviceType)inputCursor.getElemEnumValue(AwsSupportConstants.RootDeviceType.class));
            } else if (IMAGE_CONFIGURATION_ROOT_FS_SIZE_OVERRIDE.equals(elementLocalName)) {
                elasticImageConfiguration.setRootFsSizeOverride(Integer.valueOf(inputCursor.getElemIntValue()));
            } else if (IMAGE_CONFIGURATION_ARCHITECTURE.equals(elementLocalName)) {
                elasticImageConfiguration.setArchitecture((AwsSupportConstants.Architecture)inputCursor.getElemEnumValue(AwsSupportConstants.Architecture.class));
            } else if (IMAGE_CONFIGURATION_PLATFORM.equals(elementLocalName)) {
                elasticImageConfiguration.setPlatform((AwsSupportConstants.Platform)inputCursor.getElemEnumValue(AwsSupportConstants.Platform.class));
            } else if (IMAGE_CONFIGURATION_IMAGE_DISABLED.equals(elementLocalName)) {
                elasticImageConfiguration.setDisabled(inputCursor.getElemBooleanValue());
            } else if (IMAGE_CONFIGURATION_LEGACY_EBS_HANDLING.equals(elementLocalName)) {
                elasticImageConfiguration.setLegacyEbsHandlingEnabled(inputCursor.getElemBooleanValue());
            } else if (IMAGE_CONFIGURATION_PER_SECOND_BILLING.equals(elementLocalName)) {
                elasticImageConfiguration.setPerSecondBillingEnabled(inputCursor.getElemBooleanValue());
            } else if (IMAGE_CONFIGURATION_IMAGE_FILES_VERSION.equals(elementLocalName)) {
                elasticImageConfiguration.setImageFilesVersion(inputCursor.getElemStringValue());
            } else if (IMAGE_CONFIGURATION_OS_NAME.equals(elementLocalName)) {
                elasticImageConfiguration.setOsName(inputCursor.getElemStringValue());
            } else if (IMAGE_CONFIGURATION_VIRTUALIZATION_TYPE.equals(elementLocalName)) {
                elasticImageConfiguration.setVirtualisationType((AwsSupportConstants.Virtualisation)inputCursor.getElemEnumValue(AwsSupportConstants.Virtualisation.class));
            } else if (IMAGE_CONFIGURATION_CAPABILITIES.equals(elementLocalName)) {
                List capabilities = this.capabilityMapper.importListXml(inputCursor);
                ImageCapabilitySetImpl capabilitySet = new ImageCapabilitySetImpl();
                for (Capability capability : capabilities) {
                    capabilitySet.addCapability(capability);
                }
                this.capabilitySetManager.saveCapabilitySet((CapabilitySet)capabilitySet);
                elasticImageConfiguration.setCapabilitySet((ImageCapabilitySet)capabilitySet);
            } else if (IMAGE_CONFIGURATION_SUBNET.equals(elementLocalName)) {
                elasticImageConfiguration.setSubnetId(inputCursor.getElemStringValue());
            } else if (IMAGE_CONFIGURATION_SCRIPT_IDS.equals(elementLocalName)) {
                elasticImageConfiguration.setStartupScripts(this.toScriptList(inputCursor.getElemStringValue()));
            }
        }
    }

    private List<Script> toScriptList(String scriptIdsString) {
        return Pattern.compile(",").splitAsStream(scriptIdsString).map(Long::parseLong).map(arg_0 -> ((ScriptDao)this.scriptDao).findById(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static Iterable<AvailabilityZoneId> toAzs(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return Collections.emptyList();
        }
        return AvailabilityZoneId.from((Iterable)Splitter.on((char)',').split((CharSequence)string));
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull ElasticImageConfiguration imageConfiguration, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, imageConfiguration, session, exportDetailsBean);
        SMOutputElementAppender outputAppender = new SMOutputElementAppender(outputElement).append(IMAGE_CONFIGURATION_AMI_ID, imageConfiguration.getAmiId()).append(IMAGE_CONFIGURATION_NAME, imageConfiguration.getConfigurationName()).appendIfNotBlank(IMAGE_CONFIGURATION_DESCRIPTION, imageConfiguration.getConfigurationDescription()).append(IMAGE_CONFIGURATION_INSTANCE_TYPE, ElasticImageConfigurationImpl.toString((Iterable)imageConfiguration.getInstanceTypes())).appendIfNotBlank(IMAGE_CONFIGURATION_AVAILABILITY_ZONE, Joiner.on((char)',').join((Iterable)imageConfiguration.getAvailabilityZones())).append(IMAGE_CONFIGURATION_SHIPPED_WITH_BAMBOO, imageConfiguration.isShippedWithBamboo()).appendIfNotBlank(IMAGE_CONFIGURATION_PRODUCT, imageConfiguration.getProduct()).appendIfNotNull(IMAGE_CONFIGURATION_REGION, imageConfiguration.getRegion()).appendIfNotNull(IMAGE_CONFIGURATION_ROOT_DEVICE_TYPE, imageConfiguration.getRootDeviceType()).appendIfNotNull(IMAGE_CONFIGURATION_ROOT_FS_SIZE_OVERRIDE, imageConfiguration.getRootFsSizeOverride()).appendIfNotNull(IMAGE_CONFIGURATION_ARCHITECTURE, imageConfiguration.getArchitecture()).appendIfNotNull(IMAGE_CONFIGURATION_PLATFORM, imageConfiguration.getPlatform()).appendIfNotBlank(IMAGE_CONFIGURATION_SUBNET, Joiner.on((char)',').join((Iterable)imageConfiguration.getSubnetIds())).append(IMAGE_CONFIGURATION_IMAGE_DISABLED, imageConfiguration.isDisabled()).append(IMAGE_CONFIGURATION_LEGACY_EBS_HANDLING, imageConfiguration.isLegacyEbsHandlingEnabled()).appendIfNotBlank(IMAGE_CONFIGURATION_IMAGE_FILES_VERSION, imageConfiguration.getImageFilesVersion()).appendIfNotBlank(IMAGE_CONFIGURATION_OS_NAME, imageConfiguration.getOsName()).appendIfNotNull(IMAGE_CONFIGURATION_VIRTUALIZATION_TYPE, imageConfiguration.getVirtualisationType());
        if (imageConfiguration.isEbsEnabled()) {
            outputAppender.append(IMAGE_CONFIGURATION_EBS_SNAPSHOT_ID, imageConfiguration.getEbsSnapshotId());
        }
        if (!imageConfiguration.getStartupScripts().isEmpty()) {
            outputAppender.append(IMAGE_CONFIGURATION_SCRIPT_IDS, Narrow.streamDownTo(imageConfiguration.getStartupScripts().stream(), ScriptImpl.class).map(EntityObject::getId).map(Object::toString).collect(Collectors.joining(",")));
        }
        this.capabilityMapper.exportListXml(outputElement, imageConfiguration.getCapabilitySet().getCapabilities(), exportDetailsBean);
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<ElasticImageConfiguration> list, @NotNull ElasticImageConfiguration object, long objectIndex, @NotNull Session session) throws Exception {
        session.replicate((Object)object, ReplicationMode.OVERWRITE);
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        this.exportListXml(outputElement, this.elasticImageConfigurationAccessor.getAllElasticImageConfigurations(), exportDetailsBean);
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        this.importListXmlInTransaction(inputCursor);
    }
}

