/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.agent.elastic.schedule.ActiveInstanceAdjustmentType;
import com.atlassian.bamboo.agent.elastic.schedule.ElasticInstanceSchedule;
import com.atlassian.bamboo.agent.elastic.schedule.ElasticInstanceScheduleDao;
import com.atlassian.bamboo.agent.elastic.schedule.ElasticInstanceScheduleImpl;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfigurationDao;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.core.bean.EntityObject;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

public class ElasticInstanceScheduleMapper
extends BambooStAXMappingListHelperAbstractImpl<ElasticInstanceSchedule, ElasticInstanceSchedule>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(ElasticInstanceScheduleMapper.class);
    static final String SCHEDULE_XML_ROOT = "elasticInstanceSchedules";
    static final String SCHEDULE_XML_NODE = "elasticInstanceSchedule";
    static final String SCHEDULE_ENABLED = "enabled";
    static final String SCHEDULE_CRON_EXPRESSION = "cronExpression";
    static final String SCHEDULE_TARGET_ACTIVE_INSTANCES = "targetActiveInstances";
    static final String SCHEDULE_ACTIVE_INSTANCE_ADJUSTMENT_TYPE = "activeInstanceAdjustmentType";
    static final String SCHEDULE_ELASTIC_IMAGE_CONFIGURATION = "elasticImageConfiguration";
    private final ElasticInstanceScheduleDao elasticInstanceScheduleDao;
    private final ElasticImageConfigurationDao elasticImageConfigurationDao;

    protected ElasticInstanceScheduleMapper(SessionFactory sessionFactory, ElasticInstanceScheduleDao elasticInstanceScheduleDao, ElasticImageConfigurationDao elasticImageConfigurationDao, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, transactionOperations);
        this.elasticInstanceScheduleDao = elasticInstanceScheduleDao;
        this.elasticImageConfigurationDao = elasticImageConfigurationDao;
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return SCHEDULE_XML_ROOT;
    }

    @Override
    @NotNull
    public String getXmlElementNodeName() {
        return SCHEDULE_XML_NODE;
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<ElasticInstanceSchedule> elasticInstanceSchedules, @NotNull ElasticInstanceSchedule object, long objectIndex, @NotNull Session session) throws Exception {
        this.saveBambooObject(session, (BambooIdProvider)object);
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull ElasticInstanceSchedule object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, object, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).append(SCHEDULE_ENABLED, object.isEnabled()).appendIfNotBlank(SCHEDULE_CRON_EXPRESSION, object.getCronExpression()).append(SCHEDULE_TARGET_ACTIVE_INSTANCES, object.getTargetActiveInstances()).append(SCHEDULE_ACTIVE_INSTANCE_ADJUSTMENT_TYPE, object.getActiveInstanceAdjustmentType().getDatabaseId()).append(SCHEDULE_ELASTIC_IMAGE_CONFIGURATION, (EntityObject)object.getElasticImageConfiguration());
    }

    @Override
    protected void importProperties(@NotNull ElasticInstanceSchedule object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(object, inputCursor, session);
        String elementLocalName = inputCursor.getLocalName();
        if (SCHEDULE_ENABLED.equals(elementLocalName)) {
            object.setEnabled(inputCursor.getElemBooleanValue(true));
        } else if (SCHEDULE_CRON_EXPRESSION.equals(elementLocalName)) {
            object.setCronExpression(inputCursor.getElemStringValue());
        } else if (SCHEDULE_TARGET_ACTIVE_INSTANCES.equals(elementLocalName)) {
            object.setTargetActiveInstances(inputCursor.getElemIntValue(0));
        } else if (SCHEDULE_ACTIVE_INSTANCE_ADJUSTMENT_TYPE.equals(elementLocalName)) {
            int adjustmentTypeDbId = inputCursor.getElemIntValue(-1);
            ActiveInstanceAdjustmentType instanceAdjustmentType = ActiveInstanceAdjustmentType.getActiveInstanceAdjustmentType((long)adjustmentTypeDbId);
            if (instanceAdjustmentType != null) {
                object.setActiveInstanceAdjustmentType(instanceAdjustmentType);
            }
        } else if (SCHEDULE_ELASTIC_IMAGE_CONFIGURATION.equals(elementLocalName)) {
            ElasticImageConfiguration imageConfig = this.elasticImageConfigurationDao.findById(inputCursor.getElemLongValue(-1L));
            object.setElasticImageConfiguration(imageConfig);
        }
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        List schedules = this.elasticInstanceScheduleDao.findAll();
        this.exportListXml(outputElement, schedules, exportDetailsBean);
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        this.importListXmlInTransaction(inputCursor);
    }

    @Override
    @NotNull
    protected ElasticInstanceSchedule createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new ElasticInstanceScheduleImpl();
    }
}

