/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.agent.ephemeral.EphemeralAgentTemplate;
import com.atlassian.bamboo.agent.ephemeral.EphemeralAgentTemplateDao;
import com.atlassian.bamboo.agent.ephemeral.EphemeralAgentTemplateImpl;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.stream.CapabilitySetMapper;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySetManager;
import com.atlassian.bamboo.v2.build.agent.capability.EphemeralAgentTemplateCapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.EphemeralAgentTemplateCapabilitySetImpl;
import java.util.List;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ListMapper(rootNodeName="ephemeralAgentTemplates", itemNodeName="ephemeralAgentTemplate")
public class EphemeralAgentTemplateMapper
extends BambooStAXMappingListHelperAbstractImpl<EphemeralAgentTemplate, EphemeralAgentTemplate>
implements BambooStAXRootMapper {
    private static final String CONFIGURATION_NAME = "name";
    private static final String TEMPLATE = "template";
    private static final String ENABLED = "enabled";
    private static final String CAPABILITIES = "capabilities";
    private final EphemeralAgentTemplateDao ephemeralAgentTemplateDao;
    private final CapabilitySetMapper capabilityMapper;
    private final CapabilitySetManager capabilitySetManager;

    public EphemeralAgentTemplateMapper(SessionFactory sessionFactory, TransactionOperations transactionOperations, EphemeralAgentTemplateDao ephemeralAgentTemplateDao, CapabilitySetManager capabilitySetManager) {
        super(sessionFactory, transactionOperations);
        this.ephemeralAgentTemplateDao = ephemeralAgentTemplateDao;
        this.capabilityMapper = new CapabilitySetMapper(sessionFactory, transactionOperations);
        this.capabilitySetManager = capabilitySetManager;
    }

    @Override
    @NotNull
    protected EphemeralAgentTemplate createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new EphemeralAgentTemplateImpl();
    }

    @Override
    protected void importProperties(@NotNull EphemeralAgentTemplate object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(object, inputCursor, session);
        if (object instanceof EphemeralAgentTemplateImpl) {
            EphemeralAgentTemplateImpl ephemeralConfiguration = (EphemeralAgentTemplateImpl)object;
            String elementLocalName = inputCursor.getLocalName();
            if (CONFIGURATION_NAME.equals(elementLocalName)) {
                ephemeralConfiguration.setConfigurationName(inputCursor.getElemStringValue());
            } else if (TEMPLATE.equals(elementLocalName)) {
                ephemeralConfiguration.setTemplate(inputCursor.getElemStringValue());
            } else if (ENABLED.equals(elementLocalName)) {
                ephemeralConfiguration.setEnabled(inputCursor.getElemBooleanValue(false));
            } else if (CAPABILITIES.equals(elementLocalName)) {
                List capabilities = this.capabilityMapper.importListXml(inputCursor);
                EphemeralAgentTemplateCapabilitySetImpl capabilitySet = new EphemeralAgentTemplateCapabilitySetImpl();
                for (Capability capability : capabilities) {
                    capabilitySet.addCapability(capability);
                }
                this.capabilitySetManager.saveCapabilitySet((CapabilitySet)capabilitySet);
                ephemeralConfiguration.setCapabilitySet((EphemeralAgentTemplateCapabilitySet)capabilitySet);
            }
        }
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull EphemeralAgentTemplate configuration, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, configuration, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).append(CONFIGURATION_NAME, configuration.getConfigurationName()).append(TEMPLATE, configuration.getTemplate()).append(ENABLED, configuration.isEnabled());
        this.capabilityMapper.exportListXml(outputElement, configuration.getCapabilitySet().getCapabilities(), exportDetailsBean);
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        this.exportListXml(outputElement, this.ephemeralAgentTemplateDao.findAll(), exportDetailsBean);
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        Session session = this.getSession();
        this.importListXml(session, inputCursor);
        session.flush();
        session.clear();
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<EphemeralAgentTemplate> list, @NotNull EphemeralAgentTemplate object, long objectIndex, @NotNull Session session) throws Exception {
        this.saveBambooObject(session, (BambooIdProvider)object);
    }
}

