/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.core.IdGenerator;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.oid.IdGeneratorDao;
import com.atlassian.bamboo.oid.IdGeneratorEntity;
import com.atlassian.bamboo.util.Narrow;
import java.util.List;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ListMapper(rootNodeName="idGeneratorData", itemNodeName="idGeneratorEntity")
public class IdGeneratorMapper
extends BambooStAXMappingListHelperAbstractImpl<IdGenerator, IdGenerator>
implements BambooStAXRootMapper {
    private static final String NAME = "name";
    private static final String NEXT_ID = "nextId";
    private final IdGeneratorDao idGeneratorDao;

    public IdGeneratorMapper(SessionFactory sessionFactory, @NotNull TransactionOperations transactionOperations, @NotNull IdGeneratorDao idGeneratorDao) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_TRANSACTION, transactionOperations);
        this.idGeneratorDao = idGeneratorDao;
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull IdGenerator object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, object, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).append(NAME, object.getName()).append(NEXT_ID, object.getNextId());
    }

    @Override
    protected void importProperties(@NotNull IdGenerator object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        String elementLocalName;
        super.importProperties(object, inputCursor, session);
        IdGeneratorEntity idGeneratorEntity = (IdGeneratorEntity)Narrow.downTo((Object)object, IdGeneratorEntity.class);
        switch (elementLocalName = inputCursor.getLocalName()) {
            case "name": {
                idGeneratorEntity.setName(inputCursor.getElemStringValue());
                break;
            }
            case "nextId": {
                idGeneratorEntity.setNextId(inputCursor.getElemLongValue());
            }
        }
    }

    @Override
    @NotNull
    protected IdGeneratorEntity createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new IdGeneratorEntity();
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        this.exportListXml(outputElement, this.idGeneratorDao.findAll(), exportDetailsBean);
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        Session session = this.getSession();
        this.importListXml(session, inputCursor);
        session.clear();
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<IdGenerator> list, @NotNull IdGenerator object, long objectIndex, @NotNull Session session) throws Exception {
        this.idGeneratorDao.saveNextId(object.getName(), object.getNextId());
    }
}

