/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.instantmessagingserver.InstantMessagingServerDefinition;
import com.atlassian.bamboo.instantmessagingserver.InstantMessagingServerDefinitionImpl;
import com.atlassian.bamboo.instantmessagingserver.InstantMessagingServerManager;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.ReplicationMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

public class InstantMessagingServerMapper
extends BambooStAXMappingListHelperAbstractImpl<InstantMessagingServerDefinition, InstantMessagingServerDefinition>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(InstantMessagingServerMapper.class);
    static final String IMSERVER_XML_ROOT = "imservers";
    static final String IMSERVER_XML_NODE = "imserver";
    static final String IMSERVER_XML_NAME = "name";
    static final String IMSERVER_XML_HOST = "host";
    static final String IMSERVER_XML_PORT = "port";
    static final String IMSERVER_XML_USERNAME = "username";
    static final String IMSERVER_XML_PASSWORD = "password";
    static final String IMSERVER_XML_TLS = "tls";
    static final String IMSERVER_XML_SSL = "ssl";
    static final String IMSERVER_XML_RESOURCE = "resource";
    private final InstantMessagingServerManager instantMessagingServerManager;

    protected InstantMessagingServerMapper(SessionFactory sessionFactory, InstantMessagingServerManager instantMessagingServerManager, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, transactionOperations);
        this.instantMessagingServerManager = instantMessagingServerManager;
    }

    @Override
    @NotNull
    public String getXmlElementNodeName() {
        return IMSERVER_XML_NODE;
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return IMSERVER_XML_ROOT;
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<InstantMessagingServerDefinition> instantMessagingServerDefinitions, @NotNull InstantMessagingServerDefinition object, long objectIndex, @NotNull Session session) throws Exception {
        session.replicate((Object)object, ReplicationMode.OVERWRITE);
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull InstantMessagingServerDefinition object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, object, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).append(IMSERVER_XML_NAME, object.getName()).appendIfNotBlank(IMSERVER_XML_HOST, object.getHost()).appendIfNotNull(IMSERVER_XML_PORT, object.getPort()).appendIfNotBlank(IMSERVER_XML_USERNAME, object.getUsername()).appendIfNotBlank(IMSERVER_XML_PASSWORD, object.getEncryptedPassword()).append(IMSERVER_XML_TLS, object.isSecureConnectionRequired()).append(IMSERVER_XML_SSL, object.isEnforceLegacySsl()).appendIfNotBlank(IMSERVER_XML_RESOURCE, object.getResource());
    }

    @Override
    protected void importProperties(@NotNull InstantMessagingServerDefinition object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(object, inputCursor, session);
        String elementLocalName = inputCursor.getLocalName();
        if (IMSERVER_XML_NAME.equals(elementLocalName)) {
            object.setName(inputCursor.getElemStringValue());
        } else if (IMSERVER_XML_HOST.equals(elementLocalName)) {
            object.setHost(inputCursor.getElemStringValue());
        } else if (IMSERVER_XML_PORT.equals(elementLocalName)) {
            object.setPort(Integer.valueOf(inputCursor.getElemIntValue()));
        } else if (IMSERVER_XML_USERNAME.equals(elementLocalName)) {
            object.setUsername(inputCursor.getElemStringValue());
        } else if (IMSERVER_XML_PASSWORD.equals(elementLocalName)) {
            object.setPassword(inputCursor.getElemStringValue());
        } else if (IMSERVER_XML_TLS.equals(elementLocalName)) {
            object.setSecureConnectionRequired(inputCursor.getElemBooleanValue());
        } else if (IMSERVER_XML_SSL.equals(elementLocalName)) {
            object.setEnforceLegacySsl(inputCursor.getElemBooleanValue());
        } else if (IMSERVER_XML_RESOURCE.equals(elementLocalName)) {
            object.setResource(inputCursor.getElemStringValue());
        }
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        this.exportListXml(outputElement, this.instantMessagingServerManager.getAllInstantMessagingServers(), exportDetailsBean);
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        this.importListXmlInTransaction(inputCursor);
    }

    @Override
    @NotNull
    protected InstantMessagingServerDefinitionImpl createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new InstantMessagingServerDefinitionImpl();
    }
}

