/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.labels.Label;
import com.atlassian.bamboo.labels.LabelDao;
import com.atlassian.bamboo.labels.LabelImpl;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.ReplicationMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

public class LabelMapper
extends BambooStAXMappingListHelperAbstractImpl<Label, Label>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(LabelMapper.class);
    static final String LABEL_XML_ROOT = "labels";
    static final String LABEL_XML_NODE = "label";
    static final String LABEL_XML_NAME = "name";
    static final String LABEL_XML_NAMESPACE = "namespace";
    private LabelDao labelDao;

    public LabelMapper(SessionFactory sessionFactory, LabelDao labelDao, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, transactionOperations);
        this.labelDao = labelDao;
    }

    @Override
    @NotNull
    public String getXmlElementNodeName() {
        return LABEL_XML_NODE;
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor cursor, @NotNull List<Label> labels, @NotNull Label object, long objectIndex, @NotNull Session session) throws Exception {
        session.replicate((Object)object, ReplicationMode.OVERWRITE);
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return LABEL_XML_ROOT;
    }

    @Override
    protected void importProperties(@NotNull Label object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(object, inputCursor, session);
        String elementLocalName = inputCursor.getLocalName();
        if (LABEL_XML_NAME.equals(elementLocalName)) {
            object.setName(inputCursor.getElemStringValue());
        } else if (LABEL_XML_NAMESPACE.equals(elementLocalName)) {
            object.setNamespace(inputCursor.getElemStringValue());
        }
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull Label object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, object, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).append(LABEL_XML_NAME, object.getName()).appendIfNotBlank(LABEL_XML_NAMESPACE, object.getNamespace());
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        this.exportListXml(outputElement, this.labelDao.findAll(), exportDetailsBean);
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        this.importListXmlInTransaction(inputCursor);
    }

    @Override
    @NotNull
    protected Label createItemInstance(@NotNull SMInputCursor inputCursor) throws Exception {
        return new LabelImpl();
    }
}

