/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.labels.Label;
import com.atlassian.bamboo.labels.Labelling;
import com.atlassian.bamboo.labels.LabellingImpl;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import java.util.Map;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.transaction.support.TransactionOperations;

public class LabellingMapper
extends BambooStAXMappingListHelperAbstractImpl<Labelling, Labelling> {
    private static final Logger log = Logger.getLogger(LabellingMapper.class);
    public static final String LABELS_XML_ROOT = "labellings";
    static final String LABELS_XML_NODE = "labelling";
    static final String LABELS_XML_LABEL = "label";
    static final String LABELS_XML_USER = "user";
    private ResultsSummary buildResultSummary;
    private Plan plan;
    private Project project;
    private Map<Long, Label> labelMap;

    public LabellingMapper(SessionFactory sessionFactory, @Nullable ResultsSummary buildResultSummary, @Nullable Plan plan, @Nullable Project project, @NotNull Map<Long, Label> labelMap, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, transactionOperations);
        this.buildResultSummary = buildResultSummary;
        this.plan = plan;
        this.project = project;
        this.labelMap = labelMap;
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return LABELS_XML_ROOT;
    }

    @Override
    @NotNull
    public String getXmlElementNodeName() {
        return LABELS_XML_NODE;
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull Labelling object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, object, session, exportDetailsBean);
        SMOutputElementAppender appender = new SMOutputElementAppender(outputElement);
        appender.append(LABELS_XML_LABEL, object.getLabel().getId());
        if (object.getUserName() != null) {
            appender.append(LABELS_XML_USER, object.getUserName());
        }
    }

    @Override
    protected void importProperties(@NotNull Labelling object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(object, inputCursor, session);
        String elementLocalName = inputCursor.getLocalName();
        if (LABELS_XML_LABEL.equals(elementLocalName)) {
            object.setLabel(this.labelMap.get(inputCursor.getElemLongValue(0L)));
        } else if (LABELS_XML_USER.equals(elementLocalName)) {
            object.setUserName(inputCursor.getElemStringValue());
        }
    }

    @Override
    @NotNull
    protected Labelling createItemInstance(SMInputCursor inputCursor) throws Exception {
        LabellingImpl newLabelling = new LabellingImpl();
        newLabelling.setBuildResultsSummary(this.buildResultSummary);
        if (!(this.plan instanceof ImmutableJob)) {
            newLabelling.setPlan(this.plan);
        }
        newLabelling.setProject(this.project);
        return newLabelling;
    }
}

