/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssue;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssueImpl;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.MapperUtil;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.stream.LinkedJiraIssuesMapper;
import com.atlassian.bamboo.migration.stream.MapperExportException;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryImpl;
import com.atlassian.bamboo.resultsummary.LinkedJiraIssueDao;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import java.util.List;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.transaction.support.TransactionOperations;

public class LinkedJiraIssueRootMapper
extends LinkedJiraIssuesMapper
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(LinkedJiraIssueRootMapper.class);
    static final String XML_BUILD_RESULTS_SUMMARY_ID = "brsId";
    private final LinkedJiraIssueDao linkedJiraIssueDao;

    public LinkedJiraIssueRootMapper(SessionFactory sessionFactory, @NotNull LinkedJiraIssueDao linkedJiraIssueDao, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_10000_ITEMS_TRANSACTION, transactionOperations);
        this.linkedJiraIssueDao = linkedJiraIssueDao;
    }

    @Override
    public boolean isShouldExport(@NotNull ExportDetailsBean exportDetailsBean) {
        return exportDetailsBean.isExportResults();
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor cursor, @NotNull List<LinkedJiraIssue> list, @NotNull LinkedJiraIssue object, long objectIndex, @NotNull Session session) throws Exception {
        this.eventEndElementOfListItemSaveObject(session, object, objectIndex, 50L);
    }

    @Override
    protected void importProperties(@NotNull LinkedJiraIssue object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        if (object instanceof LinkedJiraIssueImpl) {
            String elementLocalName = inputCursor.getLocalName();
            if (XML_BUILD_RESULTS_SUMMARY_ID.equals(elementLocalName)) {
                object.setResultsSummary((ResultsSummary)MapperUtil.createFakeObject(BuildResultsSummaryImpl.class, inputCursor));
            } else {
                super.importProperties(object, inputCursor, session);
            }
        }
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull LinkedJiraIssue issue, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        new SMOutputElementAppender(outputElement).append(XML_BUILD_RESULTS_SUMMARY_ID, issue.getResultsSummary().getId());
        super.exportProperties(outputElement, issue, session, exportDetailsBean);
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, final ExportDetailsBean exportDetailsBean) throws Exception {
        final SMOutputElement rootElement = this.createListRootElement(outputElement);
        this.linkedJiraIssueDao.scrollJiraIssuesForExport((Consumer)new Consumer<LinkedJiraIssue>(){
            private long index = 0L;

            @Override
            public void accept(@Nullable LinkedJiraIssue linkedJiraIssue) {
                if (linkedJiraIssue != null) {
                    try {
                        LinkedJiraIssueRootMapper.this.exportXml(rootElement, linkedJiraIssue, exportDetailsBean);
                        ++this.index;
                        if (this.index % 10000L == 0L) {
                            log.info((Object)String.format("Exporting LinkedJiraIssue: %d", this.index));
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("Could not export " + linkedJiraIssue), (Throwable)e);
                        throw new MapperExportException(e);
                    }
                }
            }
        });
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        Session session = this.getSession();
        this.importListXml(session, inputCursor);
        session.clear();
    }
}

