/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.jira.jiraissues.JiraIssueLinkType;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssue;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssueImpl;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

public class LinkedJiraIssuesMapper
extends BambooStAXMappingListHelperAbstractImpl<LinkedJiraIssue, LinkedJiraIssue> {
    private static final Logger log = Logger.getLogger(LinkedJiraIssuesMapper.class);
    static final String BUILDSUMMARY_XML_LINKEDJIRAISSUES = "linkedjiraIssues";
    static final String BUILDSUMMARY_XML_LINKEDJIRAISSUE = "linkedjiraIssue";
    static final String BUILDSUMMARY_XML_LINKEDJIRAISSUE_KEY = "key";
    static final String BUILDSUMMARY_XML_LINKEDJIRAISSUE_TYPE = "type";

    public LinkedJiraIssuesMapper(SessionFactory sessionFactory, @NotNull BambooStAXListImportStrategy listImportStrategy, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, listImportStrategy, transactionOperations);
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return BUILDSUMMARY_XML_LINKEDJIRAISSUES;
    }

    @Override
    @NotNull
    public String getXmlElementNodeName() {
        return BUILDSUMMARY_XML_LINKEDJIRAISSUE;
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull LinkedJiraIssue issue, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, issue, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).append(BUILDSUMMARY_XML_LINKEDJIRAISSUE_KEY, issue.getIssueKey()).append(BUILDSUMMARY_XML_LINKEDJIRAISSUE_TYPE, issue.getIssueType().intValue());
    }

    @Override
    protected void importProperties(@NotNull LinkedJiraIssue issue, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(issue, inputCursor, session);
        String elementLocalName = inputCursor.getLocalName();
        if (BUILDSUMMARY_XML_LINKEDJIRAISSUE_KEY.equals(elementLocalName)) {
            issue.setIssueKey(inputCursor.getElemStringValue());
        } else if (BUILDSUMMARY_XML_LINKEDJIRAISSUE_TYPE.equals(elementLocalName)) {
            issue.setIssueType(JiraIssueLinkType.fromInt((int)inputCursor.getElemIntValue()));
        }
    }

    @Override
    @NotNull
    protected LinkedJiraIssue createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new LinkedJiraIssueImpl();
    }
}

