/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.mail.SMTPMailServerWithEncryptedPassword;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.mail.MailException;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

public class MailServerMapper
extends BambooStAXMappingListHelperAbstractImpl<SMTPMailServer, SMTPMailServer>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(MailServerMapper.class);
    static final String MAILSERVER_XML_ROOT = "mail-servers";
    static final String MAILSERVER_XML_SMTP = "smtp-server";
    static final String MAILSERVER_XML_NAME = "name";
    static final String MAILSERVER_XML_PREFIX = "prefix";
    static final String MAILSERVER_XML_REMOVE_PRECEDENCE = "removePrecedence";
    static final String MAILSERVER_XML_FROM = "defaultFrom";
    static final String MAILSERVER_XML_HOST = "hostname";
    static final String MAILSERVER_XML_SMTPPORT = "smtpPort";
    static final String MAILSERVER_XML_USERNAME = "username";
    static final String MAILSERVER_XML_PASSWORD = "password";
    static final String MAILSERVER_TLS_REQUIRED = "tlsRequired";
    static final String MAILSERVER_XML_JNDI = "jndi-location";
    static MailServerManager mailServerManager = null;

    protected MailServerMapper(SessionFactory sessionFactory, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_TRANSACTION, transactionOperations);
    }

    private MailServerManager getMailServerManager() {
        if (mailServerManager == null) {
            return MailFactory.getServerManager();
        }
        return mailServerManager;
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return MAILSERVER_XML_ROOT;
    }

    @Override
    @NotNull
    public String getXmlElementNodeName() {
        return MAILSERVER_XML_SMTP;
    }

    @Override
    protected void importProperties(@NotNull SMTPMailServer object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        String elementLocalName = inputCursor.getLocalName();
        if (MAILSERVER_XML_NAME.equals(elementLocalName)) {
            object.setName(inputCursor.getElemStringValue());
        } else if (MAILSERVER_XML_FROM.equals(elementLocalName)) {
            object.setDefaultFrom(inputCursor.getElemStringValue());
        } else if (MAILSERVER_XML_PREFIX.equals(elementLocalName)) {
            object.setPrefix(inputCursor.getElemStringValue());
        } else if (MAILSERVER_XML_REMOVE_PRECEDENCE.equals(elementLocalName)) {
            object.setRemovePrecedence(inputCursor.getElemBooleanValue());
        } else if (MAILSERVER_XML_JNDI.equals(elementLocalName)) {
            object.setJndiLocation(inputCursor.getElemStringValue());
            object.setSessionServer(true);
            object.setHostname(null);
            object.setPort(null);
            object.setUsername(null);
            object.setPassword(null);
        } else if (MAILSERVER_XML_HOST.equals(elementLocalName)) {
            object.setHostname(inputCursor.getElemStringValue());
        } else if (MAILSERVER_XML_SMTPPORT.equals(elementLocalName)) {
            object.setPort(inputCursor.getElemStringValue());
        } else if (MAILSERVER_XML_USERNAME.equals(elementLocalName)) {
            object.setUsername(inputCursor.getElemStringValue());
        } else if (MAILSERVER_XML_PASSWORD.equals(elementLocalName)) {
            object.setPassword(inputCursor.getElemStringValue());
        } else if (MAILSERVER_TLS_REQUIRED.equals(elementLocalName)) {
            object.setTlsRequired(inputCursor.getElemBooleanValue());
        }
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull SMTPMailServer object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        SMOutputElementAppender element = new SMOutputElementAppender(outputElement).append(MAILSERVER_XML_NAME, object.getName()).appendIfNotBlank(MAILSERVER_XML_FROM, object.getDefaultFrom()).appendIfNotBlank(MAILSERVER_XML_PREFIX, object.getPrefix()).append(MAILSERVER_XML_REMOVE_PRECEDENCE, object.isRemovePrecedence());
        if (object.isSessionServer()) {
            element.appendIfNotBlank(MAILSERVER_XML_JNDI, object.getJndiLocation());
        } else {
            element.appendIfNotBlank(MAILSERVER_XML_HOST, object.getHostname()).appendIfNotEqual(MAILSERVER_XML_SMTPPORT, object.getPort(), "25").appendIfNotBlank(MAILSERVER_XML_USERNAME, object.getUsername()).appendIfNotBlank(MAILSERVER_XML_PASSWORD, object.getPassword()).append(MAILSERVER_TLS_REQUIRED, object.isTlsRequired());
        }
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        List smtpMailServers = this.getMailServerManager().getSmtpMailServers();
        this.exportListXml(outputElement, smtpMailServers, exportDetailsBean);
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        this.clearMailServerManager();
        super.importListXml(inputCursor);
    }

    private void clearMailServerManager() throws MailException {
        MailServerManager serverManager = this.getMailServerManager();
        List serverNames = serverManager.getServerNames();
        for (String serverName : serverNames) {
            MailServer server = serverManager.getMailServer(serverName);
            serverManager.delete(server.getId());
        }
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<SMTPMailServer> smtpMailServers, @NotNull SMTPMailServer object, long objectIndex, @NotNull Session session) throws Exception {
        super.afterImportListItem(inputCursor, smtpMailServers, object, objectIndex, session);
        this.getMailServerManager().create((MailServer)object);
        this.getMailServerManager().update((MailServer)object);
    }

    @Override
    @NotNull
    protected SMTPMailServer createItemInstance(SMInputCursor inputCursor) throws Exception {
        SMTPMailServerWithEncryptedPassword mailServer = new SMTPMailServerWithEncryptedPassword();
        mailServer.setSessionServer(false);
        return mailServer;
    }
}

