/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfigurationDao;
import com.atlassian.bamboo.buildqueue.ElasticAgentDefinition;
import com.atlassian.bamboo.buildqueue.EphemeralAgentDefinition;
import com.atlassian.bamboo.buildqueue.LocalAgentDefinition;
import com.atlassian.bamboo.buildqueue.PipelineDefinition;
import com.atlassian.bamboo.buildqueue.PipelineDefinitionVisitor;
import com.atlassian.bamboo.buildqueue.RemoteAgentDefinition;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.MapperUtil;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.stream.CapabilitySetMapper;
import com.atlassian.bamboo.migration.stream.PipelineMappingStrategy;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityScope;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySetManager;
import com.atlassian.core.bean.EntityObject;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.ReplicationMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.transaction.support.TransactionOperations;

public class PipelineMapper
extends BambooStAXMappingListHelperAbstractImpl<PipelineDefinition, PipelineDefinition>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(PipelineMapper.class);
    static final String PIPELINE_XML_ROOT = "pipelines";
    static final String PIPELINE_XML_NODE = "pipeline";
    static final String PIPELINE_XML_TYPE_ATTRIBUTE = "type";
    static final String PIPELINE_XML_NAME = "name";
    static final String PIPELINE_XML_DESCRIPTION = "description";
    static final String PIPELINE_XML_START_TIME = "lastStartTime";
    static final String PIPELINE_XML_STOP_TIME = "lastStopTime";
    static final String PIPELINE_XML_CAPABILITIES = "capabilities";
    static final String PIPELINE_XML_INSTANCE_ID = "instanceId";
    static final String PIPELINE_XML_ELASTIC_IMAGE_CONFIGURATION_ID = "elasticImageConfigurationId";
    static final String PIPELINE_XML_ENABLED = "enabled";
    static final String PIPELINE_XML_UUID = "uuid";
    static final String PIPELINE_XML_LEGACY_REF_AMI_ID = "refImageAmiId";
    private Date startTime;
    private Date stopTime;
    private String instanceId;
    private String imageConfigurationId;
    private String legacyAmiId;
    private List<Capability> capabilities;
    private String type;
    private UUID uuid;
    @Lazy
    @Autowired
    private AgentManager agentManager;
    private final CapabilitySetManager capabilitySetManager;
    private final ElasticImageConfigurationDao elasticImageConfigurationDao;
    private final CapabilitySetMapper capabilityMapper;

    public PipelineMapper(SessionFactory sessionFactory, CapabilitySetManager capabilitySetManager, ElasticImageConfigurationDao elasticImageConfigurationDao, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_TRANSACTION, transactionOperations);
        this.capabilitySetManager = capabilitySetManager;
        this.elasticImageConfigurationDao = elasticImageConfigurationDao;
        this.capabilityMapper = new CapabilitySetMapper(sessionFactory, transactionOperations);
    }

    @Override
    @NotNull
    public String getXmlElementNodeName() {
        return PIPELINE_XML_NODE;
    }

    @Override
    public void beforeImportListItem(@NotNull SMInputCursor cursor, @NotNull List<PipelineDefinition> pipelineDefinitions, @NotNull Session session) throws Exception {
        this.startTime = null;
        this.stopTime = null;
        this.instanceId = null;
        this.imageConfigurationId = null;
        this.legacyAmiId = null;
        this.capabilities = new ArrayList<Capability>();
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor cursor, @NotNull List<PipelineDefinition> pipelineDefinitions, @NotNull PipelineDefinition pipeline, long objectIndex, @NotNull Session session) throws Exception {
        PipelineMappingStrategy strategy = PipelineMappingStrategy.forPipelineElement(this.type);
        PipelineDefinition newPipeline = strategy.newPipelineDefinition();
        newPipeline.setId(pipeline.getId());
        newPipeline.setCreationDate(pipeline.getCreationDate());
        newPipeline.setLastModificationDate(pipeline.getLastModificationDate());
        newPipeline.setName(pipeline.getName());
        newPipeline.setDescription(pipeline.getDescription());
        newPipeline.setEnabled(pipeline.isEnabled());
        CapabilitySet capabilitySet = strategy.newPipelineCapabilitySet(CapabilityScope.AGENT);
        this.capabilities.forEach(arg_0 -> ((CapabilitySet)capabilitySet).addCapability(arg_0));
        DefinitionImporter importer = new DefinitionImporter(newPipeline, strategy, capabilitySet);
        newPipeline.accept((PipelineDefinitionVisitor)importer);
        if (importer.hasAnyError()) {
            log.info((Object)importer.getError());
        }
        session.replicate((Object)newPipeline, ReplicationMode.OVERWRITE);
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return PIPELINE_XML_ROOT;
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        this.exportListXml(outputElement, this.getPersistedAgentDefinitionsToExport(), exportDetailsBean);
    }

    @NotNull
    private List<PipelineDefinition> getPersistedAgentDefinitionsToExport() {
        return this.agentManager.getAllPersistedAgentDefinitions().stream().filter(this::shouldAgentDefinitionBeExported).collect(Collectors.toList());
    }

    private boolean shouldAgentDefinitionBeExported(PipelineDefinition pipelineDefinition) {
        return !(pipelineDefinition instanceof EphemeralAgentDefinition);
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        this.agentManager.initAgents();
        this.importListXml(inputCursor);
    }

    @Override
    @NotNull
    protected PipelineDefinition createItemInstance(@NotNull SMInputCursor inputCursor) throws Exception {
        this.type = inputCursor.getAttrValue(PIPELINE_XML_TYPE_ATTRIBUTE);
        PipelineMappingStrategy strategy = PipelineMappingStrategy.forPipelineElement(this.type);
        if (strategy != null) {
            return strategy.newPipelineDefinition();
        }
        throw new Exception(String.format("Unrecognized pipeline type: %s", this.type));
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull PipelineDefinition object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        if (this.shouldAgentDefinitionBeExported(object)) {
            super.exportProperties(outputElement, object, session, exportDetailsBean);
            PipelineMappingStrategy.forPipelineDefinition(object).adorn(outputElement);
            new SMOutputElementAppender(outputElement).append(PIPELINE_XML_NAME, object.getName()).appendIfNotBlank(PIPELINE_XML_DESCRIPTION, object.getDescription()).append(PIPELINE_XML_ENABLED, object.isEnabled());
            DefinitionExporter exporter = new DefinitionExporter(outputElement, exportDetailsBean);
            object.accept((PipelineDefinitionVisitor)exporter);
        }
    }

    @Override
    protected void importProperties(@NotNull PipelineDefinition pipeline, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(pipeline, inputCursor, session);
        String elementLocalName = inputCursor.getLocalName();
        if (PIPELINE_XML_TYPE_ATTRIBUTE.equals(elementLocalName)) {
            this.type = inputCursor.getElemStringValue();
        } else if (PIPELINE_XML_NAME.equals(elementLocalName)) {
            pipeline.setName(inputCursor.getElemStringValue());
        } else if (PIPELINE_XML_DESCRIPTION.equals(elementLocalName)) {
            pipeline.setDescription(inputCursor.getElemStringValue());
        } else if (PIPELINE_XML_ENABLED.equals(elementLocalName)) {
            pipeline.setEnabled(inputCursor.getElemBooleanValue());
        } else if (PIPELINE_XML_START_TIME.equals(elementLocalName)) {
            this.startTime = MapperUtil.parseDateElement(inputCursor.getElemStringValue());
        } else if (PIPELINE_XML_STOP_TIME.equals(elementLocalName)) {
            this.stopTime = MapperUtil.parseDateElement(inputCursor.getElemStringValue());
        } else if (PIPELINE_XML_INSTANCE_ID.equals(elementLocalName)) {
            this.instanceId = inputCursor.getElemStringValue();
        } else if (PIPELINE_XML_ELASTIC_IMAGE_CONFIGURATION_ID.equals(elementLocalName)) {
            this.imageConfigurationId = inputCursor.getElemStringValue();
        } else if (PIPELINE_XML_CAPABILITIES.equals(elementLocalName)) {
            this.capabilities = this.capabilityMapper.importListXml(inputCursor);
        } else if (PIPELINE_XML_LEGACY_REF_AMI_ID.equals(elementLocalName)) {
            this.legacyAmiId = inputCursor.getElemStringValue();
        } else if (PIPELINE_XML_UUID.equals(elementLocalName)) {
            this.uuid = UUID.fromString(inputCursor.getElemStringValue());
        }
    }

    private class DefinitionImporter
    implements PipelineDefinitionVisitor {
        private final PipelineDefinition agent;
        private final CapabilitySet capabilitySet;
        private String error;

        public DefinitionImporter(PipelineDefinition agent, PipelineMappingStrategy strategy, CapabilitySet capabilitySet) {
            this.agent = agent;
            this.capabilitySet = capabilitySet;
        }

        public void visitElastic(ElasticAgentDefinition pipelineDefinition) {
            try {
                ElasticImageConfiguration elasticImageConfiguration = PipelineMapper.this.elasticImageConfigurationDao.findById(NumberUtils.toLong((String)PipelineMapper.this.imageConfigurationId, (long)0L));
                if (elasticImageConfiguration == null && StringUtils.isNotEmpty((CharSequence)PipelineMapper.this.legacyAmiId)) {
                    ElasticImageConfiguration shippedImage = (ElasticImageConfiguration)Iterables.getFirst((Iterable)PipelineMapper.this.elasticImageConfigurationDao.getImages(AwsSupportConstants.Region.US_EAST_1, AwsSupportConstants.RootDeviceType.S3, AwsSupportConstants.Architecture.i386, AwsSupportConstants.Platform.linux, Boolean.valueOf(true)), null);
                    if (shippedImage == null) {
                        shippedImage = (ElasticImageConfiguration)Iterables.getFirst((Iterable)PipelineMapper.this.elasticImageConfigurationDao.getImages(null, null, null, null, Boolean.valueOf(true)), null);
                    }
                    elasticImageConfiguration = shippedImage;
                }
                if (elasticImageConfiguration == null) {
                    this.error = "The definition of \"" + this.agent.getName() + "\" agent has invalid elastic image configuration associated with.";
                    return;
                }
                pipelineDefinition.setElasticImageConfiguration(elasticImageConfiguration);
            }
            catch (NumberFormatException e) {
                this.error = "An incorrect elastic image configuration reference (\"" + PipelineMapper.this.imageConfigurationId + "\")";
                return;
            }
            pipelineDefinition.setElasticInstanceId(PipelineMapper.this.instanceId);
            if (PipelineMapper.this.startTime != null) {
                pipelineDefinition.setLastStartupTime(PipelineMapper.this.startTime);
            }
            if (PipelineMapper.this.stopTime != null) {
                pipelineDefinition.setLastShutdownTime(PipelineMapper.this.stopTime);
            }
        }

        public void visitEphemeral(EphemeralAgentDefinition pipelineDefinition) {
        }

        public void visitLocal(LocalAgentDefinition pipelineDefinition) {
            PipelineMapper.this.capabilitySetManager.saveCapabilitySet(this.capabilitySet);
            pipelineDefinition.setCapabilitySet(this.capabilitySet);
        }

        public void visitRemote(RemoteAgentDefinition pipelineDefinition) {
            if (PipelineMapper.this.startTime != null) {
                pipelineDefinition.setLastStartupTime(PipelineMapper.this.startTime);
            }
            if (PipelineMapper.this.stopTime != null) {
                pipelineDefinition.setLastShutdownTime(PipelineMapper.this.stopTime);
            }
            PipelineMapper.this.capabilitySetManager.saveCapabilitySet(this.capabilitySet);
            pipelineDefinition.setCapabilitySet(this.capabilitySet);
            pipelineDefinition.setUuid(PipelineMapper.this.uuid);
        }

        public String getError() {
            return this.error;
        }

        public boolean hasAnyError() {
            return this.error != null;
        }
    }

    private class DefinitionExporter
    implements PipelineDefinitionVisitor {
        private final SMOutputElement outputElement;
        final ExportDetailsBean exportDetailsBean;

        public DefinitionExporter(SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) {
            this.outputElement = outputElement;
            this.exportDetailsBean = exportDetailsBean;
        }

        public void visitElastic(ElasticAgentDefinition pipelineDefinition) {
            try {
                new SMOutputElementAppender(this.outputElement).appendIfNotNull(PipelineMapper.PIPELINE_XML_START_TIME, pipelineDefinition.getLastStartupTime()).appendIfNotNull(PipelineMapper.PIPELINE_XML_STOP_TIME, pipelineDefinition.getLastShutdownTime()).appendIfNotBlank(PipelineMapper.PIPELINE_XML_INSTANCE_ID, pipelineDefinition.getElasticInstanceId()).append(PipelineMapper.PIPELINE_XML_ELASTIC_IMAGE_CONFIGURATION_ID, (EntityObject)pipelineDefinition.getElasticImageConfiguration());
            }
            catch (Exception e) {
                log.error((Object)"Pipeline definition export failed", (Throwable)e);
                throw new RuntimeException(e);
            }
        }

        public void visitEphemeral(EphemeralAgentDefinition pipelineDefinition) {
        }

        public void visitLocal(LocalAgentDefinition pipelineDefinition) {
            try {
                CapabilitySet capabilitySet = pipelineDefinition.getCapabilitySet();
                if (capabilitySet != null) {
                    PipelineMapper.this.capabilityMapper.exportListXml(this.outputElement, capabilitySet.getCapabilities(), this.exportDetailsBean);
                }
            }
            catch (Exception e) {
                log.error((Object)"Pipeline definition export failed", (Throwable)e);
                throw new RuntimeException(e);
            }
        }

        public void visitRemote(RemoteAgentDefinition pipelineDefinition) {
            try {
                new SMOutputElementAppender(this.outputElement).appendIfNotNull(PipelineMapper.PIPELINE_XML_START_TIME, pipelineDefinition.getLastStartupTime()).appendIfNotNull(PipelineMapper.PIPELINE_XML_STOP_TIME, pipelineDefinition.getLastShutdownTime()).appendIfNotBlank(PipelineMapper.PIPELINE_XML_UUID, pipelineDefinition.getUuid() != null ? pipelineDefinition.getUuid().toString() : null);
                CapabilitySet capabilitySet = pipelineDefinition.getCapabilitySet();
                if (capabilitySet != null) {
                    PipelineMapper.this.capabilityMapper.exportListXml(this.outputElement, capabilitySet.getCapabilities(), this.exportDetailsBean);
                }
            }
            catch (Exception e) {
                log.error((Object)"Pipeline definition export failed", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }
}

