/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.buildqueue.PipelineDefinition;
import com.atlassian.bamboo.v2.build.agent.ElasticAgentDefinitionImpl;
import com.atlassian.bamboo.v2.build.agent.LocalAgentDefinitionImpl;
import com.atlassian.bamboo.v2.build.agent.RemoteAgentDefinitionImpl;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityScope;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.ImageCapabilitySetImpl;
import com.atlassian.bamboo.v2.build.agent.capability.LocalCapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.RemoteCapabilitySet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.out.SMOutputElement;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum PipelineMappingStrategy {
    LOCAL(LocalAgentDefinitionImpl.class){

        @Override
        public CapabilitySet newPipelineCapabilitySet(CapabilityScope agent) {
            return new LocalCapabilitySet(agent);
        }

        @Override
        public PipelineDefinition newPipelineDefinition() {
            return new LocalAgentDefinitionImpl();
        }
    }
    ,
    REMOTE(RemoteAgentDefinitionImpl.class){

        @Override
        public CapabilitySet newPipelineCapabilitySet(CapabilityScope agent) {
            return new RemoteCapabilitySet(agent);
        }

        @Override
        public PipelineDefinition newPipelineDefinition() {
            return new RemoteAgentDefinitionImpl();
        }
    }
    ,
    ELASTIC(ElasticAgentDefinitionImpl.class){

        @Override
        public CapabilitySet newPipelineCapabilitySet(CapabilityScope agent) {
            return new ImageCapabilitySetImpl(agent);
        }

        @Override
        public PipelineDefinition newPipelineDefinition() {
            return new ElasticAgentDefinitionImpl();
        }
    }
    ,
    LEGACY_1_2_4(null){

        @Override
        public CapabilitySet newPipelineCapabilitySet(CapabilityScope agent) {
            return new LocalCapabilitySet(agent);
        }

        @Override
        public PipelineDefinition newPipelineDefinition() {
            return new LocalAgentDefinitionImpl();
        }
    };

    private static final Map<Class<? extends PipelineDefinition>, PipelineMappingStrategy> forPipelineDefinitionClass;
    private static final Logger log;
    private final Class<? extends PipelineDefinition> pipelineDefinitionClass;

    public static PipelineMappingStrategy forPipelineDefinition(PipelineDefinition pipelineDefinition) {
        return forPipelineDefinitionClass.get(pipelineDefinition.getClass());
    }

    @Nullable
    public static PipelineMappingStrategy forPipelineElement(String type) {
        return type == null ? LEGACY_1_2_4 : PipelineMappingStrategy.valueOf(type);
    }

    private PipelineMappingStrategy(Class<? extends PipelineDefinition> pipelineDefinitionClass) {
        this.pipelineDefinitionClass = pipelineDefinitionClass;
    }

    public void adorn(SMOutputElement outputElement) throws XMLStreamException {
        outputElement.addElement("type").addCharacters(this.name());
    }

    public abstract PipelineDefinition newPipelineDefinition();

    public abstract CapabilitySet newPipelineCapabilitySet(CapabilityScope var1);

    static {
        Map<Class<? extends PipelineDefinition>, PipelineMappingStrategy> strategies = Collections.synchronizedMap(new HashMap());
        for (PipelineMappingStrategy strategy : PipelineMappingStrategy.values()) {
            strategies.put(strategy.pipelineDefinitionClass, strategy);
        }
        forPipelineDefinitionClass = Collections.unmodifiableMap(strategies);
        log = Logger.getLogger(PipelineMappingStrategy.class);
    }
}

