/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.build.MutablePlanBranchPullRequest;
import com.atlassian.bamboo.build.PlanBranchPullRequestDao;
import com.atlassian.bamboo.build.PlanBranchPullRequestEntity;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.exception.BambooImportException;
import com.atlassian.bamboo.plan.PlanDao;
import com.atlassian.bamboo.plan.branch.ChainBranch;
import com.atlassian.bamboo.plan.pullrequest.MutableVcsPullRequest;
import com.atlassian.bamboo.plan.pullrequest.VcsPullRequestDao;
import java.util.List;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ListMapper(rootNodeName="planBranchPullRequests", itemNodeName="planBranchPullRequest")
public class PlanBranchPullRequestMapper
extends BambooStAXMappingListHelperAbstractImpl<MutablePlanBranchPullRequest, MutablePlanBranchPullRequest>
implements BambooStAXRootMapper {
    private static final String VCS_PULL_REQUEST_KEY = "pullRequestKey";
    private static final String VCS_PULL_REQUEST_REPOSITORY_ID = "repositoryId";
    private static final String CHAIN_BRANCH_KEY = "chainBranchKey";
    private final PlanBranchPullRequestDao dao;
    private final VcsPullRequestDao pullRequestDao;
    private final PlanDao planDao;
    private PlanBranchPullRequestData currentImportData;

    public PlanBranchPullRequestMapper(PlanBranchPullRequestDao dao, SessionFactory sessionFactory, TransactionOperations transactionOperations, VcsPullRequestDao pullRequestDao, PlanDao planDao) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_10000_ITEMS_TRANSACTION, transactionOperations);
        this.dao = dao;
        this.pullRequestDao = pullRequestDao;
        this.planDao = planDao;
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        this.exportListXml(outputElement, this.dao.findAll(), exportDetailsBean);
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull MutablePlanBranchPullRequest planBranchPullRequest, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, planBranchPullRequest, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).append(CHAIN_BRANCH_KEY, planBranchPullRequest.getChainBranch().getKey()).append(VCS_PULL_REQUEST_KEY, planBranchPullRequest.getVcsPullRequest().getKey()).append(VCS_PULL_REQUEST_REPOSITORY_ID, planBranchPullRequest.getVcsPullRequest().getTargetRepositoryId());
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        Session session = this.getSession();
        this.importListXml(session, inputCursor);
        session.flush();
        session.clear();
    }

    @Override
    public void beforeImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<MutablePlanBranchPullRequest> list, @NotNull Session session) throws Exception {
        this.currentImportData = new PlanBranchPullRequestData();
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<MutablePlanBranchPullRequest> list, @NotNull MutablePlanBranchPullRequest object, long objectIndex, @NotNull Session session) throws Exception {
        if (!this.currentImportData.allFieldsPresent()) {
            throw new BambooImportException("Some mandatory properties not present", inputCursor);
        }
        MutableVcsPullRequest pullRequest = this.pullRequestDao.findByRepositoryAndKey(this.currentImportData.vcsPullRequestRepositoryId.longValue(), this.currentImportData.vcsPullRequestKey);
        if (pullRequest == null) {
            String message = String.format("Pull request (%d, %s) not found", this.currentImportData.vcsPullRequestRepositoryId, this.currentImportData.vcsPullRequestKey);
            throw new BambooImportException(message, inputCursor);
        }
        ChainBranch chainBranch = (ChainBranch)this.planDao.getPlanByKey(this.currentImportData.chainBranchKey, ChainBranch.class);
        if (chainBranch == null) {
            throw new BambooImportException(String.format("Chain branch %s not found", this.currentImportData.chainBranchKey), inputCursor);
        }
        object.setVcsPullRequest(pullRequest);
        object.setChainBranch(chainBranch);
        this.saveBambooObject(session, (BambooIdProvider)object);
    }

    @Override
    protected void importProperties(@NotNull MutablePlanBranchPullRequest object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(object, inputCursor, session);
        String elementLocalName = inputCursor.getLocalName();
        if (VCS_PULL_REQUEST_KEY.equals(elementLocalName)) {
            this.currentImportData.vcsPullRequestKey = inputCursor.getElemStringValue();
        } else if (VCS_PULL_REQUEST_REPOSITORY_ID.equals(elementLocalName)) {
            this.currentImportData.vcsPullRequestRepositoryId = inputCursor.getElemLongValue();
        } else if (CHAIN_BRANCH_KEY.equals(elementLocalName)) {
            this.currentImportData.chainBranchKey = inputCursor.getElemStringValue();
        }
    }

    @Override
    @NotNull
    protected MutablePlanBranchPullRequest createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new PlanBranchPullRequestEntity();
    }

    private class PlanBranchPullRequestData {
        String vcsPullRequestKey = null;
        String chainBranchKey = null;
        Long vcsPullRequestRepositoryId = null;

        private PlanBranchPullRequestData() {
        }

        boolean allFieldsPresent() {
            return this.vcsPullRequestRepositoryId != null && this.vcsPullRequestKey != null && this.chainBranchKey != null;
        }
    }
}

