/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.build.BuildNumberExportDao;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.MapperUtil;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.plan.number.PlanBuildNumbers;
import com.atlassian.bamboo.plan.number.PlanBuildNumbersImpl;
import com.atlassian.bamboo.util.Narrow;
import java.util.List;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ListMapper(rootNodeName="planBuildNumbers", itemNodeName="buildNumbers")
public class PlanBuildNumbersMapper
extends BambooStAXMappingListHelperAbstractImpl<PlanBuildNumbers, PlanBuildNumbers>
implements BambooStAXRootMapper {
    private static final String PLAN_ID = "planId";
    private static final String FIRST_BUILD_NUMBER = "firstBuildNumber";
    private static final String LAST_BUILD_NUMBER = "lastBuildNumber";
    private static final String NEXT_BUILD_NUMBER = "nextBuildNumber";
    private final BuildNumberExportDao buildNumberExportDao;

    public PlanBuildNumbersMapper(SessionFactory sessionFactory, @NotNull TransactionOperations transactionOperations, @NotNull BuildNumberExportDao buildNumberExportDao) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_10000_ITEMS_TRANSACTION, transactionOperations);
        this.buildNumberExportDao = buildNumberExportDao;
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull PlanBuildNumbers object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, object, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).append(PLAN_ID, object.getPlanId()).append(NEXT_BUILD_NUMBER, object.getNextBuildNumber());
    }

    @Override
    protected void importProperties(@NotNull PlanBuildNumbers object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(object, inputCursor, session);
        PlanBuildNumbersImpl planBuildNumbers = (PlanBuildNumbersImpl)Narrow.downTo((Object)object, PlanBuildNumbersImpl.class);
        String elementLocalName = inputCursor.getLocalName();
        if (PLAN_ID.equals(elementLocalName)) {
            planBuildNumbers.setPlanId(inputCursor.getElemLongValue());
        } else if (NEXT_BUILD_NUMBER.equals(elementLocalName)) {
            planBuildNumbers.setNextBuildNumber(inputCursor.getElemIntValue());
        }
    }

    @Override
    @NotNull
    protected PlanBuildNumbers createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new PlanBuildNumbersImpl();
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        SMOutputElement rootElement = this.createListRootElement(outputElement);
        this.buildNumberExportDao.iteratePlanBuildNumbersForExport(MapperUtil.exportXmlFunction(this, rootElement, exportDetailsBean));
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        Session session = this.getSession();
        this.importListXml(session, inputCursor);
        session.clear();
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<PlanBuildNumbers> list, @NotNull PlanBuildNumbers object, long objectIndex, @NotNull Session session) throws Exception {
        this.saveBambooObject(session, (BambooIdProvider)object);
    }
}

