/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.chains.DefaultChain;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.exception.BambooImportException;
import com.atlassian.bamboo.plan.AbstractChain;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanDao;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.repository.PlanRepositoryLink;
import com.atlassian.bamboo.repository.PlanRepositoryLinkDao;
import com.atlassian.bamboo.repository.PlanRepositoryLinkImpl;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDataEntityImpl;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

public class PlanRepositoryLinkMapper
extends BambooStAXMappingListHelperAbstractImpl<PlanRepositoryLink, PlanRepositoryLink>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(PlanRepositoryLinkMapper.class);
    static final String PLAN_REPOSITORIES_XML_ROOT = "planRepositories";
    static final String PLAN_REPOSITORIES_XML_NODE = "planRepository";
    static final String PLAN = "plan";
    static final String REPOSITORY_DEFINITION = "repositoryDefinition";
    static final String POSITION = "position";
    private final PlanDao planDao;
    private final PlanRepositoryLinkDao planRepositoryLinkDao;
    private Map<PlanKey, Long> plansKeysToIds;

    public PlanRepositoryLinkMapper(SessionFactory sessionFactory, @NotNull PlanDao planDao, @NotNull PlanRepositoryLinkDao planRepositoryLinkDao, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.NO_TRANSACTION, transactionOperations);
        this.planDao = planDao;
        this.planRepositoryLinkDao = planRepositoryLinkDao;
    }

    @Override
    @NotNull
    protected PlanRepositoryLink createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new PlanRepositoryLinkImpl();
    }

    @Override
    @NotNull
    public String getXmlElementNodeName() {
        return PLAN_REPOSITORIES_XML_NODE;
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return PLAN_REPOSITORIES_XML_ROOT;
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<PlanRepositoryLink> planRepositories, @NotNull PlanRepositoryLink object, long objectIndex, @NotNull Session session) throws Exception {
        this.saveBambooObject(session, (BambooIdProvider)object);
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        this.exportListXml(outputElement, this.planRepositoryLinkDao.findAll(PlanRepositoryLinkImpl.class), exportDetailsBean);
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        this.plansKeysToIds = this.planDao.getPlanKeysPlanIdsMapping(AbstractChain.class);
        this.importListXml(inputCursor);
        this.plansKeysToIds.clear();
    }

    @Override
    protected void importProperties(@NotNull PlanRepositoryLink object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(object, inputCursor, session);
        String elementLocalName = inputCursor.getLocalName();
        if (PLAN.equals(elementLocalName)) {
            PlanKey planKey = PlanKeys.getPlanKey((String)inputCursor.getElemStringValue());
            Long planId = this.plansKeysToIds.get(planKey);
            if (planId == null) {
                throw new BambooImportException(String.format("Cannot find Plan [%s]", planKey.getKey()), inputCursor);
            }
            DefaultChain plan = new DefaultChain();
            plan.setId(planId.longValue());
            object.setPlan((Plan)plan);
        } else if (REPOSITORY_DEFINITION.equals(elementLocalName)) {
            long repositoryId = inputCursor.getElemLongValue();
            RepositoryDataEntityImpl repositoryDataEntity = new RepositoryDataEntityImpl();
            repositoryDataEntity.setId(repositoryId);
            object.setRepositoryDataEntity((RepositoryDataEntity)repositoryDataEntity);
        } else if (POSITION.equals(elementLocalName)) {
            object.setPosition(inputCursor.getElemIntValue());
        }
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull PlanRepositoryLink object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, object, session, exportDetailsBean);
        SMOutputElementAppender appender = new SMOutputElementAppender(outputElement);
        appender.append(PLAN, object.getPlan().getKey()).append(REPOSITORY_DEFINITION, object.getRepositoryDataEntity().getId()).append(POSITION, object.getPosition());
    }
}

