/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.stream.MapperExportException;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionHistoryItem;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionHistoryStandaloneDao;
import com.atlassian.bamboo.repository.RepositoryDefinitionDao;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.transaction.support.TransactionOperations;

public class PlanVcsRevisionHistoryMapper
extends BambooStAXMappingListHelperAbstractImpl<PlanVcsRevisionHistoryItem, PlanVcsRevisionHistoryItem>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(PlanVcsRevisionHistoryMapper.class);
    static final String XML_ROOT = "planVcsHistory";
    static final String XML_NODE = "vcsHistoryItem";
    static final String PLAN_KEY = "planKey";
    static final String BUILD_NUMBER = "buildNumber";
    static final String REVISION_KEY = "revisionKey";
    static final String REPOSITORY_ID = "repositoryId";
    static final String CUSTOM_XML = "customXmlData";
    private final PlanVcsRevisionHistoryStandaloneDao planVcsRevisionHistoryDao;
    private final RepositoryDefinitionDao repositoryDefinitionDao;
    private final ResettableLazyReference<Set<Long>> repositoryIds = new ResettableLazyReference<Set<Long>>(){

        protected Set<Long> create() throws Exception {
            return PlanVcsRevisionHistoryMapper.this.repositoryDefinitionDao.findAllRepositoryIds();
        }
    };

    public PlanVcsRevisionHistoryMapper(SessionFactory sessionFactory, PlanVcsRevisionHistoryStandaloneDao planVcsRevisionHistoryDao, RepositoryDefinitionDao repositoryDefinitionDao, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_10000_ITEMS_TRANSACTION, transactionOperations);
        this.planVcsRevisionHistoryDao = planVcsRevisionHistoryDao;
        this.repositoryDefinitionDao = repositoryDefinitionDao;
    }

    @Override
    @NotNull
    protected PlanVcsRevisionHistoryItem createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new PlanVcsRevisionHistoryItem();
    }

    @Override
    @NotNull
    public String getXmlElementNodeName() {
        return XML_NODE;
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return XML_ROOT;
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull PlanVcsRevisionHistoryItem object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, object, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).append(PLAN_KEY, object.getPlanKey().getKey()).append(BUILD_NUMBER, object.getBuildNumber()).appendIfNotBlank(REVISION_KEY, object.getVcsRevisionKey()).append(REPOSITORY_ID, object.getRepositoryId()).appendCData(CUSTOM_XML, object.getCustomXmlData());
    }

    @Override
    protected void importProperties(@NotNull PlanVcsRevisionHistoryItem object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(object, inputCursor, session);
        String elementLocalName = inputCursor.getLocalName();
        if (PLAN_KEY.equals(elementLocalName)) {
            object.setPlanKey(PlanKeys.getPlanKey((String)inputCursor.getElemStringValue()));
        } else if (BUILD_NUMBER.equals(elementLocalName)) {
            object.setBuildNumber(inputCursor.getElemIntValue());
        } else if (REVISION_KEY.equals(elementLocalName)) {
            object.setVcsRevisionKey(inputCursor.getElemStringValue());
        } else if (REPOSITORY_ID.equals(elementLocalName)) {
            object.setRepositoryId(inputCursor.getElemLongValue());
        } else if (CUSTOM_XML.equals(elementLocalName)) {
            object.setCustomXmlData(inputCursor.getElemStringValue());
        }
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, final ExportDetailsBean exportDetailsBean) throws Exception {
        final SMOutputElement rootElement = this.createListRootElement(outputElement);
        this.planVcsRevisionHistoryDao.scrollPlanVcsRevisionHistoryItemsForExport((Consumer)new Consumer<PlanVcsRevisionHistoryItem>(){

            @Override
            public void accept(@Nullable PlanVcsRevisionHistoryItem planVcsRevisionHistoryItem) {
                if (planVcsRevisionHistoryItem != null) {
                    try {
                        PlanVcsRevisionHistoryMapper.this.exportXml(rootElement, planVcsRevisionHistoryItem, exportDetailsBean);
                    }
                    catch (Exception e) {
                        log.error((Object)("Could not export " + planVcsRevisionHistoryItem), (Throwable)e);
                        throw new MapperExportException(e);
                    }
                }
            }
        });
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        this.importListXml(inputCursor);
        this.repositoryIds.reset();
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<PlanVcsRevisionHistoryItem> artifactDefinitions, @NotNull PlanVcsRevisionHistoryItem object, long objectIndex, @NotNull Session session) throws Exception {
        if (object.getRepositoryId() != -1L && ((Set)this.repositoryIds.get()).contains(object.getRepositoryId())) {
            this.saveBambooObject(session, (BambooIdProvider)object);
        } else {
            log.warn((Object)String.format("PlanVcsRevisionHistoryItem with id '%s' from plan '%s' was skipped because it has broken reference to repository", object.getId(), object.getPlanKey().getKey()));
        }
    }
}

