/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.plan.pullrequest.MutableVcsPullRequest;
import com.atlassian.bamboo.plan.pullrequest.VcsPullRequestDao;
import com.atlassian.bamboo.plan.pullrequest.VcsPullRequestImpl;
import com.atlassian.bamboo.util.Narrow;
import java.util.List;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ListMapper(rootNodeName="vcsPullRequests", itemNodeName="vcsPullRequest")
public class PullRequestMapper
extends BambooStAXMappingListHelperAbstractImpl<MutableVcsPullRequest, MutableVcsPullRequest>
implements BambooStAXRootMapper {
    private static final String KEY = "vcsPullRequestKey";
    private static final String SOURCE_REPOSITORY_ID = "sourceRepositoryId";
    private static final String SOURCE = "source";
    private static final String TARGET_REPOSITORY_ID = "targetRepositoryId";
    private static final String TARGET = "target";
    private static final String OPEN = "open";
    private static final String SOURCE_REPOSITORY_SLUG = "sourceRepositorySlug";
    private static final String SOURCE_PROJECT_KEY = "sourceProjectKey";
    private final VcsPullRequestDao pullRequestDao;
    private String sourceProjectKey;
    private String sourceRepositorySlug;

    public PullRequestMapper(VcsPullRequestDao pullRequestDao, SessionFactory sessionFactory, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_10000_ITEMS_TRANSACTION, transactionOperations);
        this.pullRequestDao = pullRequestDao;
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        this.exportListXml(outputElement, this.pullRequestDao.findAll(), exportDetailsBean);
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull MutableVcsPullRequest pullRequest, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, pullRequest, session, exportDetailsBean);
        SMOutputElementAppender appender = new SMOutputElementAppender(outputElement);
        appender.append(KEY, pullRequest.getKey()).appendIfNotNull(SOURCE_REPOSITORY_ID, pullRequest.getSourceRepositoryId()).append(SOURCE, pullRequest.getSource()).append(TARGET_REPOSITORY_ID, pullRequest.getTargetRepositoryId()).append(TARGET, pullRequest.getTarget()).append(OPEN, pullRequest.isOpen());
        if (pullRequest.getVcsForkDto() != null) {
            appender.appendIfNotBlank(SOURCE_REPOSITORY_SLUG, pullRequest.getVcsForkDto().getSourceRepositoryIdentifier()).appendIfNotBlank(SOURCE_PROJECT_KEY, pullRequest.getVcsForkDto().getSourceParentIdentifier());
        }
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        Session session = this.getSession();
        this.importListXml(session, inputCursor);
        this.sourceProjectKey = null;
        this.sourceRepositorySlug = null;
        session.flush();
        session.clear();
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<MutableVcsPullRequest> list, @NotNull MutableVcsPullRequest object, long objectIndex, @NotNull Session session) throws Exception {
        if (this.sourceRepositorySlug != null || this.sourceProjectKey != null) {
            object.setVcsForkDto(this.sourceProjectKey, this.sourceRepositorySlug);
        }
        this.sourceProjectKey = null;
        this.sourceRepositorySlug = null;
        this.saveBambooObject(session, (BambooIdProvider)object);
    }

    @Override
    protected void importProperties(@NotNull MutableVcsPullRequest object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(object, inputCursor, session);
        VcsPullRequestImpl pullRequest = (VcsPullRequestImpl)Narrow.downTo((Object)object, VcsPullRequestImpl.class);
        String elementLocalName = inputCursor.getLocalName();
        if (KEY.equals(elementLocalName)) {
            pullRequest.setKey(inputCursor.getElemStringValue());
        } else if (SOURCE_REPOSITORY_ID.equals(elementLocalName)) {
            pullRequest.setSourceRepositoryId(Long.valueOf(inputCursor.getElemLongValue()));
        } else if (SOURCE.equals(elementLocalName)) {
            pullRequest.setSource(inputCursor.getElemStringValue());
        } else if (TARGET_REPOSITORY_ID.equals(elementLocalName)) {
            pullRequest.setTargetRepositoryId(inputCursor.getElemLongValue());
        } else if (TARGET.equals(elementLocalName)) {
            pullRequest.setTarget(inputCursor.getElemStringValue());
        } else if (OPEN.equals(elementLocalName)) {
            pullRequest.setOpen(inputCursor.getElemBooleanValue());
        } else if (SOURCE_REPOSITORY_SLUG.equals(elementLocalName)) {
            this.sourceRepositorySlug = inputCursor.getElemStringValue();
        } else if (SOURCE_PROJECT_KEY.equals(elementLocalName)) {
            this.sourceProjectKey = inputCursor.getElemStringValue();
        }
    }

    @Override
    @NotNull
    protected MutableVcsPullRequest createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new VcsPullRequestImpl();
    }
}

