/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.MapperUtil;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.stream.QuickFilterRuleMapper;
import com.atlassian.bamboo.quickfilter.QuickFilter;
import com.atlassian.bamboo.quickfilter.QuickFilterDao;
import com.atlassian.bamboo.quickfilter.QuickFilterEntity;
import java.util.List;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ListMapper(rootNodeName="quickFilters", itemNodeName="quickFilter")
public class QuickFilterMapper
extends BambooStAXMappingListHelperAbstractImpl<QuickFilter, QuickFilter>
implements BambooStAXRootMapper {
    static final String XML_NAME = "name";
    static final String XML_POSITION = "position";
    static final String XML_RULES = "quickFilterRules";
    private final QuickFilterDao quickFilterDao;
    private final QuickFilterRuleMapper quickFilterRuleMapper;

    public QuickFilterMapper(SessionFactory sessionFactory, TransactionOperations transactionOperations, QuickFilterDao quickFilterDao) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_10000_ITEMS_TRANSACTION, transactionOperations);
        this.quickFilterDao = quickFilterDao;
        this.quickFilterRuleMapper = new QuickFilterRuleMapper(sessionFactory, transactionOperations);
    }

    @Override
    @NotNull
    protected QuickFilter createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new QuickFilterEntity("");
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull QuickFilter object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, object, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).append(XML_NAME, object.getName()).appendIfNotBlank(XML_POSITION, String.valueOf(object.getPosition()));
        this.quickFilterRuleMapper.exportListXml(outputElement, object.getRules(), exportDetailsBean);
    }

    @Override
    protected void importProperties(@NotNull QuickFilter object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        String elementLocalName;
        super.importProperties(object, inputCursor, session);
        switch (elementLocalName = inputCursor.getLocalName()) {
            case "name": {
                object.setName(inputCursor.getElemStringValue());
                break;
            }
            case "position": {
                object.setPosition(Integer.parseInt(inputCursor.getElemStringValue()));
                break;
            }
            case "quickFilterRules": {
                List quickFilterRules = this.quickFilterRuleMapper.importListXml(inputCursor);
                quickFilterRules.forEach(quickFilterRule -> quickFilterRule.setQuickFilter(object));
                object.setRules(quickFilterRules);
            }
        }
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        SMOutputElement rootElement = this.createListRootElement(outputElement);
        this.quickFilterDao.scrollQuickFiltersForExport(MapperUtil.exportXmlConsumer(this, rootElement, exportDetailsBean));
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        this.importListXml(inputCursor);
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<QuickFilter> quickFilters, @NotNull QuickFilter object, long objectIndex, @NotNull Session session) throws Exception {
        this.saveBambooObject(session, (BambooIdProvider)object);
        object.getRules().forEach(quickFilterRule -> this.saveBambooObject(session, (BambooIdProvider)quickFilterRule));
    }
}

