/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.quickfilter.rule.QuickFilterRule;
import com.atlassian.bamboo.quickfilter.rule.QuickFilterRuleEntity;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ListMapper(rootNodeName="quickFilterRules", itemNodeName="quickFilterRule")
public class QuickFilterRuleMapper
extends BambooStAXMappingListHelperAbstractImpl<QuickFilterRule, QuickFilterRule> {
    static final String XML_PLUGIN_KEY = "pluginKey";
    static final String XML_NAME = "name";
    static final String XML_CONFIGURATION = "configuration";
    private final Gson gson = new Gson();

    public QuickFilterRuleMapper(SessionFactory sessionFactory, TransactionOperations transactionOperations) {
        super(sessionFactory, transactionOperations);
    }

    @Override
    @NotNull
    protected QuickFilterRule createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new QuickFilterRuleEntity();
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull QuickFilterRule object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, object, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).appendIfNotBlank(XML_PLUGIN_KEY, object.getPluginKey()).appendIfNotBlank(XML_NAME, object.getName()).appendIfNotBlank(XML_CONFIGURATION, this.getSerializedConfiguration(object.getConfiguration()));
    }

    @Override
    protected void importProperties(@NotNull QuickFilterRule object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        String elementLocalName;
        super.importProperties(object, inputCursor, session);
        switch (elementLocalName = inputCursor.getLocalName()) {
            case "pluginKey": {
                object.setPluginKey(inputCursor.getElemStringValue());
                break;
            }
            case "name": {
                object.setName(inputCursor.getElemStringValue());
                break;
            }
            case "configuration": {
                object.setConfiguration(this.getConfiguration(inputCursor.getElemStringValue()));
            }
        }
    }

    private Map<String, Object> getConfiguration(String serializedConfiguration) {
        return StringUtils.isNotBlank((CharSequence)serializedConfiguration) ? new HashMap((Map)this.gson.fromJson(serializedConfiguration, Map.class)) : new HashMap();
    }

    private String getSerializedConfiguration(Map<String, Object> configuration) {
        return this.gson.toJson(configuration);
    }
}

