/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.stream.MapperExportException;
import com.atlassian.bamboo.resultsummary.vcs.RelevantChangeset;
import com.atlassian.bamboo.resultsummary.vcs.RepositoryChangesetDao;
import java.util.List;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

public class RelevantChangesetsMapper
extends BambooStAXMappingListHelperAbstractImpl<RelevantChangeset, RelevantChangeset>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(RelevantChangesetsMapper.class);
    public static final String XML_ROOT = "relevantChangesets";
    static final String XML_NODE = "relevantChangeset";
    static final String XML_RESULTSSUMMARY_ID = "brsId";
    static final String XML_REPOSITORY_CHANGESET_ID = "repositoryChangesetId";
    private final RepositoryChangesetDao repositoryChangesetDao;

    public RelevantChangesetsMapper(SessionFactory sessionFactory, @NotNull RepositoryChangesetDao repositoryChangesetDao, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_10000_ITEMS_TRANSACTION, transactionOperations);
        this.repositoryChangesetDao = repositoryChangesetDao;
    }

    @Override
    public boolean isShouldExport(@NotNull ExportDetailsBean exportDetailsBean) {
        return exportDetailsBean.isExportResults();
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return XML_ROOT;
    }

    @Override
    @NotNull
    public String getXmlElementNodeName() {
        return XML_NODE;
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull RelevantChangeset changeset, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        new SMOutputElementAppender(outputElement).append(XML_RESULTSSUMMARY_ID, changeset.brsId).append(XML_REPOSITORY_CHANGESET_ID, changeset.repositoryChangesetId);
    }

    @Override
    protected void importProperties(@NotNull RelevantChangeset changeset, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        String elementLocalName = inputCursor.getLocalName();
        long elemLongValue = inputCursor.getElemLongValue();
        if (XML_REPOSITORY_CHANGESET_ID.equals(elementLocalName)) {
            changeset.repositoryChangesetId = elemLongValue;
        } else if (XML_RESULTSSUMMARY_ID.equals(elementLocalName)) {
            changeset.brsId = elemLongValue;
        }
    }

    @Override
    @NotNull
    protected RelevantChangeset createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new RelevantChangeset();
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<RelevantChangeset> relevantChangesets, @NotNull RelevantChangeset relevantChangeset, long objectIndex, @NotNull Session session) throws Exception {
        relevantChangesets.add(relevantChangeset);
        if (relevantChangesets.size() % 1000 == 0) {
            this.repositoryChangesetDao.saveRelevantChangesets(relevantChangesets);
            relevantChangesets.clear();
        }
    }

    @Override
    @NotNull
    public List<RelevantChangeset> importListXml(@NotNull Session session, @NotNull SMInputCursor inputCursor) throws Exception {
        List<RelevantChangeset> relevantChangesets = super.importListXml(session, inputCursor);
        this.repositoryChangesetDao.saveRelevantChangesets(relevantChangesets);
        relevantChangesets.clear();
        return relevantChangesets;
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, final ExportDetailsBean exportDetailsBean) throws Exception {
        final SMOutputElement rootElement = this.createListRootElement(outputElement);
        this.repositoryChangesetDao.scrollRelevantChangesetsForExport((Consumer)new Consumer<RelevantChangeset>(){
            private long index = 0L;

            @Override
            public void accept(RelevantChangeset changeset) {
                try {
                    RelevantChangesetsMapper.this.exportXml(rootElement, changeset, exportDetailsBean);
                    if (++this.index % 10000L == 0L) {
                        log.info((Object)String.format("Exporting Repository Changeset: %d", this.index));
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Could not export changeset", (Throwable)e);
                    throw new MapperExportException(e);
                }
            }
        });
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        Session session = this.getSession();
        this.importListXml(session, inputCursor);
        session.clear();
    }
}

