/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.buildqueue.RemoteAgentAuthenticationEntity;
import com.atlassian.bamboo.buildqueue.RemoteAgentAuthenticationImpl;
import com.atlassian.bamboo.buildqueue.dao.RemoteAgentAuthenticationDao;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

public class RemoteAgentAuthenticationMapper
extends BambooStAXMappingListHelperAbstractImpl<RemoteAgentAuthenticationEntity, RemoteAgentAuthenticationEntity>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(RemoteAgentAuthenticationMapper.class);
    private static final String XML_ROOT = "remoteAgentAuthentications";
    private static final String XML_NODE = "remoteAgentAuthentication";
    private static final String IP = "ip";
    private static final String UUID = "uuid";
    private static final String IS_APPROVED = "approved";
    private final RemoteAgentAuthenticationDao remoteAgentAuthenticationDao;

    public RemoteAgentAuthenticationMapper(SessionFactory sessionFactory, @NotNull RemoteAgentAuthenticationDao remoteAgentAuthenticationDao, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, transactionOperations);
        this.remoteAgentAuthenticationDao = remoteAgentAuthenticationDao;
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor cursor, @NotNull List<RemoteAgentAuthenticationEntity> list, @NotNull RemoteAgentAuthenticationEntity object, long objectIndex, @NotNull Session session) throws Exception {
        this.eventEndElementOfListItemSaveObject(session, object, objectIndex, 50L);
    }

    @Override
    @NotNull
    protected RemoteAgentAuthenticationEntity createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new RemoteAgentAuthenticationImpl();
    }

    @Override
    @NotNull
    public String getXmlElementNodeName() {
        return XML_NODE;
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return XML_ROOT;
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull RemoteAgentAuthenticationEntity object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, object, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).append(IP, object.getIp()).appendIfNotBlank(UUID, object.getUuidAsString()).append(IS_APPROVED, object.isApproved());
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        this.exportListXml(outputElement, this.remoteAgentAuthenticationDao.getAllAuthentications(), exportDetailsBean);
    }

    @Override
    protected void importProperties(@NotNull RemoteAgentAuthenticationEntity object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        String elementLocalName = inputCursor.getLocalName();
        super.importProperties(object, inputCursor, session);
        if (IP.equals(elementLocalName)) {
            object.setIp(inputCursor.getElemStringValue());
        } else if (UUID.equals(elementLocalName)) {
            object.setUuidAsString(inputCursor.getElemStringValue());
        } else if (IS_APPROVED.equals(elementLocalName)) {
            object.setApproved(inputCursor.getElemBooleanValue());
        }
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        Session session = this.getSession();
        this.importListXml(session, inputCursor);
        session.clear();
    }
}

