/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.stream.MapperExportException;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDataEntityImpl;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryImpl;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.vcs.RepositoryChangeset;
import com.atlassian.bamboo.resultsummary.vcs.RepositoryChangesetDao;
import com.atlassian.bamboo.resultsummary.vcs.RepositoryChangesetImpl;
import java.util.List;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.transaction.support.TransactionOperations;

public class RepositoryChangesetMapper
extends BambooStAXMappingListHelperAbstractImpl<RepositoryChangeset, RepositoryChangeset>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(RepositoryChangesetMapper.class);
    public static final String XML_ROOT = "changesets";
    static final String XML_NODE = "changeset";
    static final String XML_RESULTSSUMMARY_ID = "brsId";
    static final String XML_REPOSITORY_ID = "repositoryId";
    static final String XML_SKIPPED_COMMITS_COUNT = "skippedCommitsCount";
    static final String XML_CHANGESET_ID = "changesetId";
    static final String XML_POSITION = "position";
    static final String XML_BUILD_TRIGGER = "buildTrigger";
    private final RepositoryChangesetDao repositoryChangesetDao;

    public RepositoryChangesetMapper(SessionFactory sessionFactory, @NotNull RepositoryChangesetDao repositoryChangesetDao, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_10000_ITEMS_TRANSACTION, transactionOperations);
        this.repositoryChangesetDao = repositoryChangesetDao;
    }

    @Override
    public boolean isShouldExport(@NotNull ExportDetailsBean exportDetailsBean) {
        return exportDetailsBean.isExportResults();
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return XML_ROOT;
    }

    @Override
    @NotNull
    public String getXmlElementNodeName() {
        return XML_NODE;
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull RepositoryChangeset changeset, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, changeset, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).append(XML_RESULTSSUMMARY_ID, changeset.getResultsSummary().getId()).append(XML_REPOSITORY_ID, changeset.getRepositoryData().getId()).appendIfNotBlank(XML_CHANGESET_ID, changeset.getChangesetId()).append(XML_SKIPPED_COMMITS_COUNT, changeset.getSkippedCommitsCount()).append(XML_POSITION, changeset.getPosition()).append(XML_BUILD_TRIGGER, changeset.isBuildTrigger());
    }

    @Override
    protected void importProperties(@NotNull RepositoryChangeset changeset, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(changeset, inputCursor, session);
        String elementLocalName = inputCursor.getLocalName();
        if (XML_REPOSITORY_ID.equals(elementLocalName)) {
            RepositoryDataEntityImpl repositoryDataEntity = new RepositoryDataEntityImpl();
            repositoryDataEntity.setId(inputCursor.getElemLongValue());
            changeset.setRepositoryData((RepositoryDataEntity)repositoryDataEntity);
        } else if (XML_RESULTSSUMMARY_ID.equals(elementLocalName)) {
            BuildResultsSummaryImpl buildResultsSummary = new BuildResultsSummaryImpl();
            buildResultsSummary.setId(inputCursor.getElemLongValue());
            changeset.setResultsSummary((ResultsSummary)buildResultsSummary);
        } else if (XML_SKIPPED_COMMITS_COUNT.equals(elementLocalName)) {
            changeset.setSkippedCommitsCount(inputCursor.getElemLongValue());
        } else if (XML_CHANGESET_ID.equals(elementLocalName)) {
            changeset.setChangesetId(inputCursor.getElemStringValue());
        } else if (XML_POSITION.equals(elementLocalName)) {
            changeset.setPosition(inputCursor.getElemIntValue());
        } else if (XML_BUILD_TRIGGER.equals(elementLocalName)) {
            changeset.setBuildTrigger(inputCursor.getElemBooleanValue());
        }
    }

    @Override
    @NotNull
    protected RepositoryChangeset createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new RepositoryChangesetImpl();
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<RepositoryChangeset> repositoryChangesets, @NotNull RepositoryChangeset object, long objectIndex, @NotNull Session session) throws Exception {
        this.eventEndElementOfListItemSaveObject(session, object, objectIndex, 50L);
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, final ExportDetailsBean exportDetailsBean) throws Exception {
        final SMOutputElement rootElement = this.createListRootElement(outputElement);
        this.repositoryChangesetDao.scrollChangesetsForExport((Consumer)new Consumer<RepositoryChangeset>(){
            private long index = 0L;

            @Override
            public void accept(@Nullable RepositoryChangeset changeset) {
                if (changeset != null) {
                    try {
                        RepositoryChangesetMapper.this.exportXml(rootElement, changeset, exportDetailsBean);
                        ++this.index;
                        if (this.index % 10000L == 0L) {
                            log.info((Object)String.format("Exporting Repository Changeset: %d", this.index));
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("Could not export " + changeset), (Throwable)e);
                        throw new MapperExportException(e);
                    }
                }
            }
        });
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        Session session = this.getSession();
        this.importListXml(session, inputCursor);
        session.clear();
    }
}

