/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.deletion.Deletable;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.utils.DeletableInterfaceMapper;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDataEntityImpl;
import com.atlassian.bamboo.repository.RepositoryDefinitionDao;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ListMapper(rootNodeName="repositories", itemNodeName="repository")
public class RepositoryDefinitionMapper
extends BambooStAXMappingListHelperAbstractImpl<RepositoryDataEntity, RepositoryDataEntity>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(RepositoryDefinitionMapper.class);
    private static final String NAME = "name";
    private static final String PLUGIN_KEY = "pluginKey";
    private static final String DESCRIPTION = "description";
    private static final String XML_DATA = "xml";
    private static final String PARENT = "parent";
    private static final String IS_GLOBAL = "isGlobal";
    private static final String PROJECT_ID = "projectId";
    private final RepositoryDefinitionDao repositoryDefinitionDao;

    public RepositoryDefinitionMapper(SessionFactory sessionFactory, RepositoryDefinitionDao repositoryDefinitionDao, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, transactionOperations);
        this.repositoryDefinitionDao = repositoryDefinitionDao;
    }

    public RepositoryDefinitionMapper(SessionFactory sessionFactory, @NotNull BambooStAXListImportStrategy listImportStrategy, RepositoryDefinitionDao repositoryDefinitionDao, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, listImportStrategy, transactionOperations);
        this.repositoryDefinitionDao = repositoryDefinitionDao;
    }

    @Override
    @NotNull
    protected RepositoryDataEntityImpl createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new RepositoryDataEntityImpl();
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull RepositoryDataEntity repositoryDataEntity, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, repositoryDataEntity, session, exportDetailsBean);
        SMOutputElementAppender appender = new SMOutputElementAppender(outputElement);
        appender.append(NAME, repositoryDataEntity.getName()).appendIfNotBlank(DESCRIPTION, repositoryDataEntity.getDescription()).append(PLUGIN_KEY, repositoryDataEntity.getPluginKey()).append(IS_GLOBAL, repositoryDataEntity.isGlobal()).appendCData(XML_DATA, repositoryDataEntity.getXmlData()).appendIfNotNull(PROJECT_ID, repositoryDataEntity.getProjectId());
        if (repositoryDataEntity.getParent() != null) {
            appender.append(PARENT, repositoryDataEntity.getParent().getId());
        }
        DeletableInterfaceMapper.exportProperties(appender, (Deletable)repositoryDataEntity);
    }

    @Override
    protected void importProperties(@NotNull RepositoryDataEntity repositoryDataEntity, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(repositoryDataEntity, inputCursor, session);
        String elementLocalName = inputCursor.getLocalName();
        if (NAME.equals(elementLocalName)) {
            repositoryDataEntity.setName(inputCursor.getElemStringValue());
        } else if (DESCRIPTION.equals(elementLocalName)) {
            repositoryDataEntity.setDescription(inputCursor.getElemStringValue());
        } else if (PLUGIN_KEY.equals(elementLocalName)) {
            repositoryDataEntity.setPluginKey(inputCursor.getElemStringValue());
        } else if (XML_DATA.equals(elementLocalName)) {
            repositoryDataEntity.setXmlData(inputCursor.getElemStringValue());
        } else if (DeletableInterfaceMapper.isApplicable(elementLocalName)) {
            DeletableInterfaceMapper.importProperties((Deletable)repositoryDataEntity, inputCursor);
        } else if (IS_GLOBAL.equals(elementLocalName)) {
            repositoryDataEntity.setGlobal(inputCursor.getElemBooleanValue());
        } else if (PARENT.equals(elementLocalName)) {
            RepositoryDataEntityImpl fakeParent = new RepositoryDataEntityImpl();
            fakeParent.setId(inputCursor.getElemLongValue());
            repositoryDataEntity.setParent((RepositoryDataEntity)fakeParent);
        } else if (PROJECT_ID.equals(elementLocalName)) {
            repositoryDataEntity.setProjectId(Long.valueOf(inputCursor.getElemLongValue()));
        }
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<RepositoryDataEntity> repositoryDefinitions, @NotNull RepositoryDataEntity object, long objectIndex, @NotNull Session session) throws Exception {
        this.saveBambooObject(session, (BambooIdProvider)object);
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        Collection allRepositories = this.repositoryDefinitionDao.findAll(RepositoryDataEntityImpl.class);
        HashSet<Long> alreadyProcessed = new HashSet<Long>();
        ArrayList<RepositoryDataEntity> unprocessed = Lists.newArrayList((Iterable)allRepositories);
        ArrayList<RepositoryDataEntity> sortedForExport = new ArrayList<RepositoryDataEntity>();
        while (!unprocessed.isEmpty()) {
            int initialSize = unprocessed.size();
            ArrayList<RepositoryDataEntity> stillUnprocessed = new ArrayList<RepositoryDataEntity>();
            for (RepositoryDataEntity repositoryDataEntity : unprocessed) {
                if (!alreadyProcessed.contains(repositoryDataEntity.getId()) && (repositoryDataEntity.getParent() == null || alreadyProcessed.contains(repositoryDataEntity.getParent().getId()))) {
                    alreadyProcessed.add(repositoryDataEntity.getId());
                    sortedForExport.add(repositoryDataEntity);
                    continue;
                }
                stillUnprocessed.add(repositoryDataEntity);
            }
            unprocessed = stillUnprocessed;
            if (unprocessed.size() <= 0 || unprocessed.size() != initialSize) continue;
            throw new IllegalStateException("There are repositories with missing parents");
        }
        this.exportListXml(outputElement, sortedForExport, exportDetailsBean);
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        this.importListXml(inputCursor);
    }
}

