/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.capability.LocalCapabilitySetDao;
import com.atlassian.bamboo.capability.RemoteCapabilitySetDao;
import com.atlassian.bamboo.migration.BambooStAXMappingHelper;
import com.atlassian.bamboo.migration.BambooStAXMappingHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.stream.LocalCapabilitySetMapper;
import com.atlassian.bamboo.migration.stream.RemoteCapabilitySetMapper;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityScope;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.LocalCapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.RemoteCapabilitySet;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

public class SharedCapabilityMapper
extends BambooStAXMappingHelperAbstractImpl<BambooStAXMappingHelper.None, BambooStAXMappingHelper.None>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(SharedCapabilityMapper.class);
    static final String SHARED_CAPABILITIES = "sharedCapabilities";
    private final LocalCapabilitySetMapper localCapabilityMapper;
    private final RemoteCapabilitySetMapper remoteCapabilityMapper;
    private final LocalCapabilitySetDao localCapabilityDao;
    private final RemoteCapabilitySetDao remoteCapabilityDao;

    protected SharedCapabilityMapper(SessionFactory sessionFactory, LocalCapabilitySetDao localCapabilityDao, RemoteCapabilitySetDao remoteCapabilityDao, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, transactionOperations);
        this.localCapabilityDao = localCapabilityDao;
        this.remoteCapabilityDao = remoteCapabilityDao;
        this.localCapabilityMapper = new LocalCapabilitySetMapper(sessionFactory, transactionOperations);
        this.remoteCapabilityMapper = new RemoteCapabilitySetMapper(sessionFactory, transactionOperations);
    }

    @Override
    protected void importProperties(@NotNull BambooStAXMappingHelper.None object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        String elementLocalName = inputCursor.getLocalName();
        if ("local".equals(elementLocalName)) {
            List capabilities = this.localCapabilityMapper.importListXml(inputCursor);
            LocalCapabilitySet capabilitySet = new LocalCapabilitySet(CapabilityScope.SHARED);
            for (Capability capability : capabilities) {
                capabilitySet.addCapability(capability);
            }
            this.localCapabilityDao.saveCapabilitySet((CapabilitySet)capabilitySet);
        } else if ("remote".equals(elementLocalName)) {
            List capabilities = this.remoteCapabilityMapper.importListXml(inputCursor);
            RemoteCapabilitySet capabilitySet = new RemoteCapabilitySet(CapabilityScope.SHARED);
            for (Capability capability : capabilities) {
                capabilitySet.addCapability(capability);
            }
            this.remoteCapabilityDao.saveCapabilitySet((CapabilitySet)capabilitySet);
        }
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull BambooStAXMappingHelper.None object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        CapabilitySet localCapabilities = this.localCapabilityDao.getSharedCapabilitySet();
        this.localCapabilityMapper.exportListXml(outputElement, localCapabilities.getCapabilities(), exportDetailsBean);
        CapabilitySet remoteCapabilities = this.remoteCapabilityDao.getSharedCapabilitySet();
        this.remoteCapabilityMapper.exportListXml(outputElement, remoteCapabilities.getCapabilities(), exportDetailsBean);
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return SHARED_CAPABILITIES;
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        this.exportXml(outputElement, BambooStAXMappingHelper.None.INSTANCE, exportDetailsBean);
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        this.importXml(inputCursor);
    }

    @Override
    @NotNull
    protected BambooStAXMappingHelper.None createItemInstance(SMInputCursor inputCursor) throws Exception {
        return BambooStAXMappingHelper.None.INSTANCE;
    }
}

