/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.security.trustedapplications.BambooTrustedApplication;
import com.atlassian.bamboo.security.trustedapplications.BambooTrustedApplicationDao;
import com.atlassian.bamboo.security.trustedapplications.BambooTrustedApplicationImpl;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.transaction.support.TransactionOperations;

public class TrustedApplicationsMapper
extends BambooStAXMappingListHelperAbstractImpl<BambooTrustedApplication, BambooTrustedApplication>
implements BambooStAXRootMapper {
    static final String TRUSTED_APP_XML_ROOT = "trustedApps";
    static final String TRUSTED_APP_XML_NODE = "trustedApp";
    static final String TRUSTED_APP_XML_ID = "applicationId";
    static final String TRUSTED_APP_XML_PUBLIC_KEY = "publicKey";
    static final String TRUSTED_APP_XML_NAME = "name";
    static final String TRUSTED_APP_XML_TIMEOUT = "timeout";
    static final String TRUSTED_APP_XML_URL_PATTERN = "urlPattern";
    static final String TRUSTED_APP_XML_IP_PATTERN = "ipPattern";
    @Lazy
    @Autowired
    private BambooTrustedApplicationDao bambooTrustedApplicationDao;

    public TrustedApplicationsMapper(SessionFactory sessionFactory, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, transactionOperations);
    }

    @Override
    @NotNull
    protected BambooTrustedApplication createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new BambooTrustedApplicationImpl();
    }

    @Override
    @NotNull
    public String getXmlElementNodeName() {
        return TRUSTED_APP_XML_NODE;
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return TRUSTED_APP_XML_ROOT;
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        Collection trustedApps = this.bambooTrustedApplicationDao.findAll(BambooTrustedApplication.class);
        this.exportListXml(outputElement, trustedApps, exportDetailsBean);
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        super.importListXml(inputCursor);
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull BambooTrustedApplication object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        SMOutputElementAppender appender = new SMOutputElementAppender(outputElement).appendIfNotBlank(TRUSTED_APP_XML_ID, object.getApplicationId()).appendIfNotBlank(TRUSTED_APP_XML_PUBLIC_KEY, object.getPublicKey()).appendIfNotBlank(TRUSTED_APP_XML_NAME, object.getName()).appendIfNotBlank(TRUSTED_APP_XML_TIMEOUT, object.getTimeout().toString());
        for (String urlPattern : object.getUrlPatterns()) {
            appender = appender.appendIfNotBlank(TRUSTED_APP_XML_URL_PATTERN, urlPattern);
        }
        for (String ipPattern : object.getIpPatterns()) {
            appender = appender.appendIfNotBlank(TRUSTED_APP_XML_IP_PATTERN, ipPattern);
        }
    }

    @Override
    protected void importProperties(@NotNull BambooTrustedApplication object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        if (object instanceof BambooTrustedApplicationImpl) {
            BambooTrustedApplicationImpl trustedApp = (BambooTrustedApplicationImpl)object;
            String elementLocalName = inputCursor.getLocalName();
            if (TRUSTED_APP_XML_ID.equals(elementLocalName)) {
                trustedApp.setApplicationId(inputCursor.getElemStringValue());
            } else if (TRUSTED_APP_XML_PUBLIC_KEY.equals(elementLocalName)) {
                trustedApp.setPublicKey(inputCursor.getElemStringValue());
            } else if (TRUSTED_APP_XML_NAME.equals(elementLocalName)) {
                trustedApp.setName(inputCursor.getElemStringValue());
            } else if (TRUSTED_APP_XML_TIMEOUT.equals(elementLocalName)) {
                trustedApp.setTimeout(Long.valueOf(inputCursor.getElemLongValue()));
            } else if (TRUSTED_APP_XML_URL_PATTERN.equals(elementLocalName)) {
                Sets.SetView withAppendedValue = Sets.union((Set)trustedApp.getUrlPatterns(), (Set)ImmutableSet.of((Object)inputCursor.getElemStringValue()));
                trustedApp.setUrlPatterns((Set)withAppendedValue);
            } else if (TRUSTED_APP_XML_IP_PATTERN.equals(elementLocalName)) {
                Sets.SetView withAppendedValue = Sets.union((Set)trustedApp.getIpPatterns(), (Set)ImmutableSet.of((Object)inputCursor.getElemStringValue()));
                trustedApp.setIpPatterns((Set)withAppendedValue);
            }
        }
    }
}

