/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.chains.DefaultChain;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.exception.BambooImportException;
import com.atlassian.bamboo.plan.AbstractPlan;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanDao;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableDefinitionDao;
import com.atlassian.bamboo.variable.VariableDefinitionImpl;
import com.atlassian.bamboo.variable.VariableType;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ListMapper(rootNodeName="variableDefinitions", itemNodeName="definition")
public class VariableDefinitionMapper
extends BambooStAXMappingListHelperAbstractImpl<VariableDefinition, VariableDefinition>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(VariableDefinitionMapper.class);
    static final String KEY = "key";
    static final String VALUE = "value";
    static final String VARIABLE_TYPE = "variableType";
    static final String PLAN = "plan";
    static final String DEPLOYMENT_VERSION_ID = "deploymentVersionId";
    static final String ENVIRONMENT_ID = "environmentId";
    static final String PROJECT_ID = "projectId";
    private final VariableDefinitionDao variableDefinitionDao;
    private final PlanDao planDao;
    private Map<PlanKey, Long> plansKeysToIds;

    public VariableDefinitionMapper(SessionFactory sessionFactory, VariableDefinitionDao variableDefinitionDao, PlanDao planDao, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_10000_ITEMS_TRANSACTION, transactionOperations);
        this.variableDefinitionDao = variableDefinitionDao;
        this.planDao = planDao;
    }

    @Override
    @NotNull
    protected VariableDefinition createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new VariableDefinitionImpl();
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull VariableDefinition variableDefinition, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, variableDefinition, session, exportDetailsBean);
        SMOutputElementAppender appender = new SMOutputElementAppender(outputElement).append(KEY, variableDefinition.getKey()).appendIfNotBlank(VALUE, variableDefinition.getValue()).append(VARIABLE_TYPE, variableDefinition.getVariableType().name()).appendIfNotNull(DEPLOYMENT_VERSION_ID, variableDefinition.getDeploymentVersionId()).appendIfNotNull(ENVIRONMENT_ID, variableDefinition.getEnvironmentId()).appendIfNotNull(PROJECT_ID, variableDefinition.getProjectId());
        Plan plan = variableDefinition.getPlan();
        if (plan != null) {
            appender.append(PLAN, plan.getKey());
        }
    }

    @Override
    protected void importProperties(@NotNull VariableDefinition object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(object, inputCursor, session);
        String elementLocalName = inputCursor.getLocalName();
        if (KEY.equals(elementLocalName)) {
            object.setKey(inputCursor.getElemStringValue());
        } else if (VALUE.equals(elementLocalName)) {
            object.setValue(inputCursor.getElemStringValue());
        } else if (VARIABLE_TYPE.equals(elementLocalName)) {
            object.setVariableType(VariableType.valueOf((String)inputCursor.getElemStringValue()));
        } else if (DEPLOYMENT_VERSION_ID.equals(elementLocalName)) {
            object.setDeploymentVersionId(Long.valueOf(inputCursor.getElemLongValue()));
        } else if (ENVIRONMENT_ID.equals(elementLocalName)) {
            object.setEnvironmentId(Long.valueOf(inputCursor.getElemLongValue()));
        } else if (PLAN.equals(elementLocalName)) {
            PlanKey planKey = PlanKeys.getPlanKey((String)inputCursor.getElemStringValue());
            Long planId = this.plansKeysToIds.get(planKey);
            if (planId == null) {
                throw new BambooImportException(String.format("Cannot find Plan [%s]", planKey.getKey()), inputCursor);
            }
            DefaultChain plan = new DefaultChain();
            plan.setId(planId.longValue());
            object.setPlan((Plan)plan);
        } else if (PROJECT_ID.equals(elementLocalName)) {
            object.setProjectId(Long.valueOf(inputCursor.getElemLongValue()));
        }
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<VariableDefinition> variableDefinitions, @NotNull VariableDefinition object, long objectIndex, @NotNull Session session) throws Exception {
        this.saveBambooObject(session, (BambooIdProvider)object);
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        this.exportListXml(outputElement, this.variableDefinitionDao.findAll(), exportDetailsBean);
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        this.plansKeysToIds = this.planDao.getPlanKeysPlanIdsMapping(AbstractPlan.class);
        this.importListXml(inputCursor);
        this.plansKeysToIds.clear();
    }
}

