/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.stream.MapperExportException;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryDao;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryImpl;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.variable.VariableSubstitution;
import com.atlassian.bamboo.variable.VariableSubstitutionImpl;
import com.atlassian.bamboo.variable.VariableType;
import java.util.List;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.transaction.support.TransactionOperations;

@ListMapper(rootNodeName="variableSubstitutions", itemNodeName="substitution")
public class VariableSubstitutionMapper
extends BambooStAXMappingListHelperAbstractImpl<VariableSubstitution, VariableSubstitution>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(VariableSubstitutionMapper.class);
    static final String KEY = "key";
    static final String VALUE = "value";
    static final String VARIABLE_TYPE = "variableType";
    static final String RESULTS_SUMMARY_ID = "resultSummaryId";
    private final BuildResultsSummaryDao buildResultsSummaryDao;

    public VariableSubstitutionMapper(SessionFactory sessionFactory, @NotNull BuildResultsSummaryDao buildResultsSummaryDao, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_10000_ITEMS_TRANSACTION, transactionOperations);
        this.buildResultsSummaryDao = buildResultsSummaryDao;
    }

    @Override
    public boolean isShouldExport(@NotNull ExportDetailsBean exportDetailsBean) {
        return exportDetailsBean.isExportResults();
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor cursor, @NotNull List<VariableSubstitution> list, @NotNull VariableSubstitution object, long objectIndex, @NotNull Session session) throws Exception {
        this.eventEndElementOfListItemSaveObject(session, object, objectIndex, 50L);
    }

    @Override
    @NotNull
    protected VariableSubstitution createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new VariableSubstitutionImpl();
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull VariableSubstitution object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, object, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).append(KEY, object.getKey()).appendIfNotBlank(VALUE, object.getValue()).append(VARIABLE_TYPE, object.getVariableType().toString()).append(RESULTS_SUMMARY_ID, object.getResultSummary().getId());
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, final ExportDetailsBean exportDetailsBean) throws Exception {
        final SMOutputElement rootElement = this.createListRootElement(outputElement);
        this.buildResultsSummaryDao.scrollVariableSubstitutionForExport((Consumer)new Consumer<VariableSubstitution>(){
            private long index = 0L;

            @Override
            public void accept(@Nullable VariableSubstitution variableSubstitution) {
                if (variableSubstitution != null) {
                    try {
                        VariableSubstitutionMapper.this.exportXml(rootElement, variableSubstitution, exportDetailsBean);
                        ++this.index;
                        if (this.index % 10000L == 0L) {
                            log.info((Object)String.format("Exporting VariableSubstitution: %d", this.index));
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("Could not export " + variableSubstitution), (Throwable)e);
                        throw new MapperExportException(e);
                    }
                }
            }
        });
    }

    @Override
    protected void importProperties(@NotNull VariableSubstitution object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        String elementLocalName = inputCursor.getLocalName();
        if (RESULTS_SUMMARY_ID.equals(elementLocalName)) {
            long buildResultsSummaryId = inputCursor.getElemLongValue();
            BuildResultsSummaryImpl buildResultsSummary = new BuildResultsSummaryImpl();
            buildResultsSummary.setId(buildResultsSummaryId);
            object.setResultSummary((ResultsSummary)buildResultsSummary);
        } else {
            super.importProperties(object, inputCursor, session);
            if (KEY.equals(elementLocalName)) {
                object.setKey(inputCursor.getElemStringValue());
            } else if (VALUE.equals(elementLocalName)) {
                object.setValue(inputCursor.getElemStringValue());
            } else if (VARIABLE_TYPE.equals(elementLocalName)) {
                object.setVariableType(VariableType.valueOf((String)inputCursor.getElemStringValue()));
            }
        }
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        Session session = this.getSession();
        this.importListXml(session, inputCursor);
        session.clear();
    }
}

