/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.DefaultChain;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.MapperUtil;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.plan.branch.BambooVcsBranch;
import com.atlassian.bamboo.plan.branch.BambooVcsBranchImpl;
import com.atlassian.bamboo.plan.branch.VcsBranchDao;
import java.util.List;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ListMapper(rootNodeName="vcsBranches", itemNodeName="vcsBranch")
public class VcsBranchMapper
extends BambooStAXMappingListHelperAbstractImpl<BambooVcsBranch, BambooVcsBranch>
implements BambooStAXRootMapper {
    private static final String NAME = "name";
    private static final String CHAIN_ID = "chainId";
    private static final String DELETION_STATE = "deletionState";
    private final VcsBranchDao vcsBranchDao;

    public VcsBranchMapper(SessionFactory sessionFactory, VcsBranchDao vcsBranchHibernateDao, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_TRANSACTION, transactionOperations);
        this.vcsBranchDao = vcsBranchHibernateDao;
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor cursor, @NotNull List<BambooVcsBranch> list, @NotNull BambooVcsBranch branch, long objectIndex, @NotNull Session session) throws Exception {
        this.saveBambooObject(session, (BambooIdProvider)branch);
    }

    @Override
    @NotNull
    protected BambooVcsBranch createItemInstance(SMInputCursor inputCursor) throws Exception {
        BambooVcsBranchImpl branch = new BambooVcsBranchImpl();
        branch.setChain((Chain)new DefaultChain());
        return branch;
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull BambooVcsBranch branch, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, branch, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).append(NAME, branch.getName()).append(CHAIN_ID, branch.getChain().getId()).appendIfNotNull(DELETION_STATE, branch.getDetectedDeletionDate());
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        this.exportListXml(outputElement, this.vcsBranchDao.findAll(BambooVcsBranch.class), exportDetailsBean);
    }

    @Override
    protected void importProperties(@NotNull BambooVcsBranch branch, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        String elementLocalName = inputCursor.getLocalName();
        super.importProperties(branch, inputCursor, session);
        if (NAME.equals(elementLocalName)) {
            branch.setName(inputCursor.getElemStringValue());
        } else if (CHAIN_ID.equals(elementLocalName)) {
            ((DefaultChain)branch.getChain()).setId(inputCursor.getElemLongValue());
        } else if (DELETION_STATE.equals(elementLocalName)) {
            branch.setDetectedDeletionDate(MapperUtil.parseDateElement(inputCursor.getElemStringValue()));
        }
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        Session session = this.getSession();
        this.importListXml(session, inputCursor);
        session.flush();
        session.clear();
    }
}

