/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.MapperUtil;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.web.HttpMethod;
import com.atlassian.bamboo.webhook.WebhookTemplate;
import com.atlassian.bamboo.webhook.WebhookTemplateDao;
import com.atlassian.bamboo.webhook.WebhookTemplateEntity;
import java.util.List;
import java.util.UUID;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ListMapper(rootNodeName="webhookTemplates", itemNodeName="webhookTemplate")
public class WebhookTemplateMapper
extends BambooStAXMappingListHelperAbstractImpl<WebhookTemplate, WebhookTemplateEntity>
implements BambooStAXRootMapper {
    private static final String HEADERS = "headers";
    private static final String PAYLOAD = "payload";
    private static final String HTTP_METHOD = "httpMethod";
    private static final String NAME = "name";
    private static final String UUID = "uuid";
    private final WebhookTemplateDao webhookTemplateDao;

    protected WebhookTemplateMapper(SessionFactory sessionFactory, TransactionOperations transactionOperations, WebhookTemplateDao webhookTemplateDao) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_10000_ITEMS_TRANSACTION, transactionOperations);
        this.webhookTemplateDao = webhookTemplateDao;
    }

    @Override
    @NotNull
    protected WebhookTemplateEntity createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new WebhookTemplateEntity();
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull WebhookTemplate object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, object, session, exportDetailsBean);
        WebhookTemplateEntity webhookTemplateEntity = (WebhookTemplateEntity)Narrow.to((Object)object, WebhookTemplateEntity.class);
        if (webhookTemplateEntity != null) {
            new SMOutputElementAppender(outputElement).appendIfNotBlank(HEADERS, webhookTemplateEntity.getHeaders()).appendIfNotBlank(PAYLOAD, webhookTemplateEntity.getPayload()).append(NAME, webhookTemplateEntity.getName()).append(HTTP_METHOD, webhookTemplateEntity.getHttpMethod().name()).append(UUID, webhookTemplateEntity.getUuid().toString());
        }
    }

    @Override
    protected void importProperties(@NotNull WebhookTemplateEntity object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        String elementLocalName;
        super.importProperties(object, inputCursor, session);
        switch (elementLocalName = inputCursor.getLocalName()) {
            case "headers": {
                object.setHeaders(inputCursor.getElemStringValue());
                break;
            }
            case "payload": {
                object.setPayload(inputCursor.getElemStringValue());
                break;
            }
            case "name": {
                object.setName(inputCursor.getElemStringValue());
                break;
            }
            case "httpMethod": {
                object.setHttpMethod(HttpMethod.resolve((String)inputCursor.getElemStringValue()));
                break;
            }
            case "uuid": {
                object.setUuid(java.util.UUID.fromString(inputCursor.getElemStringValue()));
            }
        }
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        SMOutputElement rootElement = this.createListRootElement(outputElement);
        this.webhookTemplateDao.scrollTokensForExport(MapperUtil.exportXmlConsumer(this, rootElement, exportDetailsBean));
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        this.importListXml(inputCursor);
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<WebhookTemplateEntity> webhookTemplates, @NotNull WebhookTemplateEntity object, long objectIndex, @NotNull Session session) throws Exception {
        this.saveBambooObject(session, (BambooIdProvider)object);
    }
}

