/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream.activeobjects;

import com.atlassian.activeobjects.spi.Backup;
import com.atlassian.bamboo.migration.BambooStreamRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.stream.activeobjects.ActiveObjectsBackupProgressMonitor;
import com.atlassian.bamboo.migration.stream.activeobjects.ActiveObjectsRestoreProgressMonitor;
import com.atlassian.bamboo.spring.ComponentAccessor;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Supplier;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ActiveObjectsMapper
implements BambooStreamRootMapper {
    private static final Logger log = Logger.getLogger(ActiveObjectsMapper.class);
    private final Supplier<Backup> activeObjectsBackup = ComponentAccessor.newOsgiServiceProxy(Backup.class);

    @Override
    public boolean isShouldExport(@NotNull ExportDetailsBean exportDetailsBean) {
        return true;
    }

    @Override
    @NotNull
    public String getFileName() {
        return "activeObjects.xml";
    }

    @Override
    public void exportData(@NotNull OutputStream outputStream, ExportDetailsBean exportDetailsBean) throws Exception {
        this.activeObjectsBackup.get().save(outputStream, ActiveObjectsBackupProgressMonitor.INSTANCE);
    }

    @Override
    public void importData(@NotNull InputStream inputStream) throws Exception {
        this.activeObjectsBackup.get().restore(inputStream, ActiveObjectsRestoreProgressMonitor.INSTANCE);
    }
}

