/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream.build;

import com.atlassian.bamboo.author.ExtendedAuthor;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainStage;
import com.atlassian.bamboo.chains.ChainStorageTag;
import com.atlassian.bamboo.labels.Label;
import com.atlassian.bamboo.labels.Labelling;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.stream.AbstractPlanMapper;
import com.atlassian.bamboo.migration.stream.BuildResultWarningSummaryMapper;
import com.atlassian.bamboo.migration.stream.build.ChainResultMapper;
import com.atlassian.bamboo.migration.stream.build.ChainStageMapper;
import com.atlassian.bamboo.migration.stream.notifications.NotificationSetMapper;
import com.atlassian.bamboo.notification.NotificationSet;
import com.atlassian.bamboo.plan.AbstractChain;
import com.atlassian.bamboo.plan.PlanDao;
import com.atlassian.bamboo.plan.rss.PlanVcsBambooSpecsSourceDtoImpl;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionHistoryStandaloneDao;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.repository.PlanRepositoryLinkDao;
import com.atlassian.bamboo.repository.RepositoryDefinitionDao;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryDao;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.resultsummary.warning.BuildResultWarningSummaryDao;
import com.atlassian.bamboo.variable.baseline.VariableContextBaselineDao;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.ReplicationMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

public abstract class AbstractChainMapper<T extends Chain>
extends AbstractPlanMapper<T> {
    private static final Logger log = Logger.getLogger(AbstractChainMapper.class);
    private static final String STAGE_XML_ROOT = "stages";
    private static final String CHAIN_RESULT_ROOT = "results";
    private static final String PLAN_XML_STORAGE_TAG = "storageTag";
    protected static final String PLAN_XML_SPECS_SOURCE = "specsSource";
    private final PlanDao planDao;
    private final ResultsSummaryManager resultsSummaryManager;
    private final BuildResultsSummaryDao buildResultSummaryDao;
    private final BuildResultWarningSummaryDao buildResultWarningSummaryDao;
    private final VariableContextBaselineDao variableContextBaselineDao;
    private Long vcsBambooSpecsSourceId;

    public AbstractChainMapper(@NotNull SessionFactory sessionFactory, @NotNull Project project, @NotNull Map<Long, Label> labelMap, @NotNull Map<Long, ExtendedAuthor> authorMap, @NotNull PlanDao planDao, ResultsSummaryManager resultsSummaryManager, BuildResultsSummaryDao buildResultSummaryDao, BuildResultWarningSummaryDao buildResultWarningSummaryDao, PlanVcsRevisionHistoryStandaloneDao planVcsRevisionHistoryDao, VariableContextBaselineDao variableContextBaselineDao, @NotNull RepositoryDefinitionDao repositoryDefinitionDao, @NotNull PlanRepositoryLinkDao planRepositoryLinkDao, @NotNull NotificationSetMapper notificationSetMapper, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_ITEM_AND_CLEAR_SESSION_TRANSACTION, project, labelMap, authorMap, planVcsRevisionHistoryDao, planDao, repositoryDefinitionDao, planRepositoryLinkDao, notificationSetMapper, transactionOperations);
        this.planDao = planDao;
        this.variableContextBaselineDao = variableContextBaselineDao;
        this.resultsSummaryManager = resultsSummaryManager;
        this.buildResultSummaryDao = buildResultSummaryDao;
        this.buildResultWarningSummaryDao = buildResultWarningSummaryDao;
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull T plan, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, plan, session, exportDetailsBean);
        ChainStorageTag storageTag = plan.getStorageTag();
        if (storageTag != null) {
            new SMOutputElementAppender(outputElement).append(PLAN_XML_STORAGE_TAG, storageTag.toString());
        }
        ChainStageMapper mapper = new ChainStageMapper(this.getSessionFactory(), (Chain)plan, this.planDao, this.transactionOperations);
        mapper.exportListXml(outputElement, plan.getAllStages(), exportDetailsBean);
        NotificationSet notificationSet = ((AbstractChain)plan).getNotificationSetField();
        this.notificationSetMapper.exportXml(session, outputElement, notificationSet, exportDetailsBean);
        if (exportDetailsBean.isExportResults()) {
            ChainResultMapper chainResultMapper = new ChainResultMapper(this.getSessionFactory(), (Chain)plan, this.buildResultSummaryDao, this.variableContextBaselineDao, new BuildResultWarningSummaryMapper(this.getSessionFactory(), this.buildResultWarningSummaryDao, this.transactionOperations), this.resultsSummaryManager, (Map<Long, Label>)this.labelMap, this.transactionOperations);
            chainResultMapper.exportListXml(outputElement, Collections.emptyList(), exportDetailsBean);
        }
    }

    @Override
    protected void importProperties(@NotNull T chain, @NotNull SMInputCursor cursor, @NotNull Session session) throws Exception {
        long specsSourceId;
        String elementLocalName = cursor.getLocalName();
        super.importProperties(chain, cursor, session);
        if (STAGE_XML_ROOT.equals(elementLocalName)) {
            ChainStageMapper mapper = new ChainStageMapper(this.getSessionFactory(), (Chain)chain, this.planDao, this.transactionOperations);
            mapper.importListXml(cursor);
        } else if (CHAIN_RESULT_ROOT.equals(elementLocalName)) {
            ChainResultMapper mapper = new ChainResultMapper(this.getSessionFactory(), (Chain)chain, this.buildResultSummaryDao, this.variableContextBaselineDao, new BuildResultWarningSummaryMapper(this.getSessionFactory(), this.buildResultWarningSummaryDao, this.transactionOperations), this.resultsSummaryManager, (Map<Long, Label>)this.labelMap, this.transactionOperations);
            mapper.importListXml(cursor);
            this.labels.addAll(mapper.getLabels());
        } else if (this.notificationSetMapper.getXmlRootNodeName().equals(elementLocalName)) {
            chain.setNotificationSet((NotificationSet)this.notificationSetMapper.importXml(session, cursor));
        } else if (PLAN_XML_STORAGE_TAG.equals(elementLocalName)) {
            chain.setStorageTag(new ChainStorageTag(cursor.getElemStringValue()));
        } else if (PLAN_XML_SPECS_SOURCE.equals(elementLocalName) && (specsSourceId = cursor.getElemLongValue(-1L)) > 0L) {
            this.vcsBambooSpecsSourceId = specsSourceId;
        }
    }

    @Override
    @NotNull
    protected T createItemInstance(SMInputCursor inputCursor) throws Exception {
        this.vcsBambooSpecsSourceId = null;
        return (T)((Chain)super.createItemInstance(inputCursor));
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<T> list, @NotNull T object, long objectIndex, @NotNull Session session) throws Exception {
        NotificationSet notificationSet = ((AbstractChain)object).getNotificationSetField();
        session.saveOrUpdate((Object)notificationSet);
        session.replicate(object, ReplicationMode.OVERWRITE);
        for (ChainStage chainStage : object.getStages()) {
            for (Job job : chainStage.getJobs()) {
                job.setStage(chainStage);
            }
        }
        session.replicate(object, ReplicationMode.OVERWRITE);
        for (Labelling label : this.labels) {
            session.replicate((Object)label, ReplicationMode.OVERWRITE);
        }
        if (this.planBuildNumbers != null) {
            this.planBuildNumbers.setPlanId(object.getId());
            session.save((Object)this.planBuildNumbers);
        }
        if (this.vcsBambooSpecsSourceId != null) {
            session.save((Object)new PlanVcsBambooSpecsSourceDtoImpl(object.getId(), this.vcsBambooSpecsSourceId.longValue()));
        }
    }
}

