/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream.build;

import com.atlassian.bamboo.build.PlanDependency;
import com.atlassian.bamboo.build.PlanDependencyManager;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.plan.PlanDao;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

public abstract class AbstractProjectDependencyMapper
extends BambooStAXMappingListHelperAbstractImpl<PlanDependency, PlanDependency>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(AbstractProjectDependencyMapper.class);
    static final String DEPENDENCIES_XML_ROOT = "dependencies";
    static final String DEPENDENCY_XML_NODE = "dependency";
    static final String PARENT_XML_NODE = "parent";
    static final String CHILD_XML_NODE = "child";
    protected PlanDao planDao;
    protected PlanDependencyManager planDependencyManager;

    protected AbstractProjectDependencyMapper(SessionFactory sessionFactory, PlanDao planDao, PlanDependencyManager planDependencyManager, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, transactionOperations);
        this.planDao = planDao;
        this.planDependencyManager = planDependencyManager;
    }

    protected AbstractProjectDependencyMapper(SessionFactory sessionFactory, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, transactionOperations);
    }

    protected void saveDependency(PlanDependency planDependency) {
        if (planDependency.getChildPlan() == null || planDependency.getParentPlan() == null) {
            log.error((Object)"Could not map dependency correctly, one of the parties was null");
        } else {
            boolean success = this.planDependencyManager.savePlanDependency(planDependency);
            if (!success) {
                log.error((Object)"Could not save plan dependency, possible already exists in the database");
            }
        }
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<PlanDependency> planDependencies, @NotNull PlanDependency object, long objectIndex, @NotNull Session session) throws Exception {
        this.saveDependency(object);
    }
}

