/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream.build;

import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.author.ExtendedAuthor;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.labels.Label;
import com.atlassian.bamboo.migration.BambooStAXMappingHelperAbstractImpl;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ItemMapper;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.MapperUtil;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.stream.build.AbstractChainMapper;
import com.atlassian.bamboo.migration.stream.notifications.NotificationSetMapper;
import com.atlassian.bamboo.plan.PlanDao;
import com.atlassian.bamboo.plan.branch.BranchCommitInformation;
import com.atlassian.bamboo.plan.branch.BranchCommitInformationImpl;
import com.atlassian.bamboo.plan.branch.ChainBranch;
import com.atlassian.bamboo.plan.branch.ChainBranchImpl;
import com.atlassian.bamboo.plan.branch.MutablePlanBranchMetadata;
import com.atlassian.bamboo.plan.branch.PlanBranchMetadata;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionHistoryStandaloneDao;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.repository.PlanRepositoryLinkDao;
import com.atlassian.bamboo.repository.RepositoryDefinitionDao;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryDao;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.resultsummary.warning.BuildResultWarningSummaryDao;
import com.atlassian.bamboo.variable.baseline.VariableContextBaselineDao;
import java.util.Map;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ListMapper(rootNodeName="branches", itemNodeName="branch")
public class ChainBranchMapper
extends AbstractChainMapper<ChainBranch> {
    private static final Logger log = Logger.getLogger(ChainBranchMapper.class);
    public static final String XML_ROOT = "branches";
    public static final String XML_NODE = "branch";
    public static final String XML_BRANCH_COMMIT_INFORMATION = "commitInformation";
    public static final String XML_BRANCH_METADATA = "branchMetadata";
    public static final String XML_LINKED_JIRA_ISSUE = "linkedJiraIssue";
    public static final String XML_REMOTE_JIRA_LINK_REQUIRED = "remoteJiraLinkRequired";
    public static final String XML_DIVERGENT_BRANCH = "divergentBranch";

    public ChainBranchMapper(@NotNull SessionFactory sessionFactory, @NotNull Project project, @NotNull Map<Long, Label> labelMap, @NotNull Map<Long, ExtendedAuthor> authorMap, PlanDao planDao, ResultsSummaryManager resultsSummaryManager, BuildResultsSummaryDao buildResultSummaryDao, BuildResultWarningSummaryDao buildResultWarningSummaryDao, PlanVcsRevisionHistoryStandaloneDao planVcsRevisionHistoryDao, VariableContextBaselineDao variableContextBaselineDao, @NotNull RepositoryDefinitionDao repositoryDefinitionDao, @NotNull PlanRepositoryLinkDao planRepositoryLinkDao, @NotNull NotificationSetMapper notificationSetMapper, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, project, labelMap, authorMap, planDao, resultsSummaryManager, buildResultSummaryDao, buildResultWarningSummaryDao, planVcsRevisionHistoryDao, variableContextBaselineDao, repositoryDefinitionDao, planRepositoryLinkDao, notificationSetMapper, transactionOperations);
    }

    @Override
    public ChainBranch createPlanEntity() {
        return new ChainBranchImpl();
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull ChainBranch plan, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, plan, session, exportDetailsBean);
        BranchCommitInformation bci = plan.getCommitInformation();
        if (bci != null) {
            BranchCommitInformationMapper bcim = new BranchCommitInformationMapper(this.getSessionFactory(), plan, this.transactionOperations);
            bcim.exportXml(session, outputElement, bci, exportDetailsBean);
        }
        BranchMetadataMapper bmm = new BranchMetadataMapper(this.getSessionFactory(), plan, this.transactionOperations);
        bmm.exportXml(session, outputElement, plan.getMetadata(), exportDetailsBean);
        new SMOutputElementAppender(outputElement).appendIfNotBlank(XML_LINKED_JIRA_ISSUE, plan.getLinkedJiraIssue()).append(XML_REMOTE_JIRA_LINK_REQUIRED, plan.isRemoteJiraLinkRequired()).append(XML_DIVERGENT_BRANCH, plan.isDivergent());
    }

    @Override
    protected void importProperties(@NotNull ChainBranch chain, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        String elementLocalName = inputCursor.getLocalName();
        super.importProperties(chain, inputCursor, session);
        if (XML_BRANCH_COMMIT_INFORMATION.equals(elementLocalName)) {
            BranchCommitInformationMapper bcim = new BranchCommitInformationMapper(this.getSessionFactory(), chain, this.transactionOperations);
            chain.setCommitInformation((BranchCommitInformation)bcim.importXml(session, inputCursor));
        } else if (XML_LINKED_JIRA_ISSUE.equals(elementLocalName)) {
            chain.setLinkedJiraIssue(inputCursor.getElemStringValue());
        } else if (XML_REMOTE_JIRA_LINK_REQUIRED.equals(elementLocalName)) {
            chain.setRemoteJiraLinkRequired(inputCursor.getElemBooleanValue(false));
        } else if (XML_DIVERGENT_BRANCH.equals(elementLocalName)) {
            chain.setDivergent(inputCursor.getElemBooleanValue(false));
        } else if (XML_BRANCH_METADATA.equals(elementLocalName)) {
            BranchMetadataMapper bmm = new BranchMetadataMapper(this.getSessionFactory(), chain, this.transactionOperations);
            chain.setMetadata((PlanBranchMetadata)bmm.importXml(session, inputCursor));
        }
    }

    @ItemMapper(rootNodeName="commitInformation")
    private class BranchCommitInformationMapper
    extends BambooStAXMappingHelperAbstractImpl<BranchCommitInformation, BranchCommitInformation> {
        private static final String CREATING_CHANGESET_ID = "creatingChangesetId";
        private static final String CREATING_AUTHOR = "creatingAuthor";
        private static final String CREATING_COMMIT_DATE = "creatingCommitDate";
        private static final String LATEST_CHANGESET_ID = "latestChangesetId";
        private static final String LATEST_COMMIT_AUTHOR = "latestCommitAuthorId";
        private static final String LATEST_COMMIT_DATE = "latestCommitDate";
        private final ChainBranch chainBranch;

        protected BranchCommitInformationMapper(SessionFactory sessionFactory, @NotNull ChainBranch chainBranch, TransactionOperations transactionOperations) {
            super(sessionFactory, transactionOperations);
            this.chainBranch = chainBranch;
        }

        @Override
        protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull BranchCommitInformation object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
            super.exportProperties(outputElement, object, session, exportDetailsBean);
            SMOutputElementAppender appender = new SMOutputElementAppender(outputElement).appendIfNotBlank(CREATING_CHANGESET_ID, object.getCreatingChangeSetId()).appendIfNotNull(CREATING_COMMIT_DATE, object.getCreatingCommitDate()).appendIfNotBlank(LATEST_CHANGESET_ID, object.getLatestCommitChangeSetId()).appendIfNotNull(LATEST_COMMIT_DATE, object.getLatestCommitDate());
            if (object.getCreatingAuthor() != null) {
                appender.append(CREATING_AUTHOR, ((BambooIdProvider)object.getCreatingAuthor()).getId());
            }
            if (object.getLatestCommitAuthor() != null) {
                appender.append(LATEST_COMMIT_AUTHOR, ((BambooIdProvider)object.getLatestCommitAuthor()).getId());
            }
        }

        @Override
        protected void importProperties(@NotNull BranchCommitInformation commitInformation, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
            super.importProperties(commitInformation, inputCursor, session);
            String elementLocalName = inputCursor.getLocalName();
            if (CREATING_CHANGESET_ID.equals(elementLocalName)) {
                commitInformation.setCreatingChangeSetId(inputCursor.getElemStringValue());
            } else if (CREATING_COMMIT_DATE.equals(elementLocalName)) {
                commitInformation.setCreatingCommitDate(MapperUtil.parseDateElement(inputCursor.getElemStringValue()));
            } else if (LATEST_CHANGESET_ID.equals(elementLocalName)) {
                commitInformation.setLatestCommitChangeSetId(inputCursor.getElemStringValue());
            } else if (LATEST_COMMIT_DATE.equals(elementLocalName)) {
                commitInformation.setLatestCommitDate(MapperUtil.parseDateElement(inputCursor.getElemStringValue()));
            } else if (CREATING_AUTHOR.equals(elementLocalName)) {
                commitInformation.setCreatingAuthor((Author)ChainBranchMapper.this.authorMap.get(inputCursor.getElemLongValue()));
            } else if (LATEST_COMMIT_AUTHOR.equals(elementLocalName)) {
                commitInformation.setLatestCommitAuthor((Author)ChainBranchMapper.this.authorMap.get(inputCursor.getElemLongValue()));
            }
        }

        @Override
        @NotNull
        protected BranchCommitInformation createItemInstance(SMInputCursor inputCursor) throws Exception {
            return new BranchCommitInformationImpl(this.chainBranch.getId());
        }
    }

    @ItemMapper(rootNodeName="branchMetadata")
    private static class BranchMetadataMapper
    extends BambooStAXMappingHelperAbstractImpl<PlanBranchMetadata, MutablePlanBranchMetadata> {
        private final ChainBranch chainBranch;
        private static final String XML_BRANCH_NAME = "branchName";
        private static final String XML_BRANCH_DISPLAY_NAME = "branchDisplayName";
        private static final String XML_VCS_REPOSITORY_ID = "repositoryId";

        protected BranchMetadataMapper(SessionFactory sessionFactory, ChainBranch chainBranch, @NotNull TransactionOperations transactionOperations) {
            super(sessionFactory, transactionOperations);
            this.chainBranch = chainBranch;
        }

        @Override
        protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull PlanBranchMetadata object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
            super.exportProperties(outputElement, object, session, exportDetailsBean);
            SMOutputElementAppender appender = new SMOutputElementAppender(outputElement);
            if (object.getVcsBranch() != null) {
                appender.appendIfNotBlank(XML_BRANCH_NAME, object.getVcsBranch().getName()).appendIfNotBlank(XML_BRANCH_DISPLAY_NAME, object.getVcsBranch().getDisplayName());
            }
            appender.appendIfNotNull(XML_VCS_REPOSITORY_ID, object.getVcsRepositoryId());
        }

        @Override
        protected void importProperties(@NotNull MutablePlanBranchMetadata object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
            super.importProperties(object, inputCursor, session);
            String elementLocalName = inputCursor.getLocalName();
            if (XML_BRANCH_NAME.equals(elementLocalName)) {
                object.setBranchName(inputCursor.getElemStringValue());
            } else if (XML_BRANCH_DISPLAY_NAME.equals(elementLocalName)) {
                object.setBranchDisplayName(inputCursor.getElemStringValue());
            } else if (XML_VCS_REPOSITORY_ID.equals(elementLocalName)) {
                object.setVcsRepositoryId(Long.valueOf(inputCursor.getElemLongValue()));
            }
        }

        @Override
        @NotNull
        protected MutablePlanBranchMetadata createItemInstance(SMInputCursor inputCursor) throws Exception {
            MutablePlanBranchMetadata newMetadata = new MutablePlanBranchMetadata(this.chainBranch);
            newMetadata.setId(this.chainBranch.getId());
            return newMetadata;
        }
    }
}

