/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream.build;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.chains.ChainStage;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.utils.BuildKeyHolder;
import com.atlassian.bamboo.plan.PlanDao;
import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

public class ChainBuildMapper
extends BambooStAXMappingListHelperAbstractImpl<BuildKeyHolder, BuildKeyHolder> {
    private static final Logger log = Logger.getLogger(ChainBuildMapper.class);
    private static final String STAGE_XML_BUILDS_ROOT = "builds";
    private static final String STAGE_XML_BUILDS_NODE = "build";
    private static final String STAGE_XML_BUILD_KEY_NODE = "buildKey";
    private final ChainStage stage;
    private final PlanDao planDao;

    protected ChainBuildMapper(SessionFactory sessionFactory, @NotNull ChainStage stage, @NotNull PlanDao planDao, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.NO_TRANSACTION, transactionOperations);
        this.stage = stage;
        this.planDao = planDao;
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return STAGE_XML_BUILDS_ROOT;
    }

    @Override
    @NotNull
    public String getXmlElementNodeName() {
        return STAGE_XML_BUILDS_NODE;
    }

    @Override
    @NotNull
    protected BuildKeyHolder createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new BuildKeyHolder();
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<BuildKeyHolder> buildKeyHolders, @NotNull BuildKeyHolder buildKeyHolder, long objectIndex, @NotNull Session session) throws Exception {
        Job job = (Job)this.planDao.getPlanByKey(buildKeyHolder.getBuildKey(), Job.class);
        Preconditions.checkNotNull((Object)job, (Object)("Job " + buildKeyHolder.getBuildKey() + " not found"));
        this.stage.getJobs().add(job);
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull BuildKeyHolder object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, object, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).append(STAGE_XML_BUILD_KEY_NODE, object.getBuildKey());
    }

    @Override
    protected void importProperties(@NotNull BuildKeyHolder buildKeyHolder, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        String elementLocalName = inputCursor.getLocalName();
        if (STAGE_XML_BUILD_KEY_NODE.equals(elementLocalName)) {
            buildKeyHolder.setBuildKey(inputCursor.getElemStringValue());
        }
    }
}

