/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream.build;

import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ChainResultsSummaryImpl;
import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.chains.ChainStageResultImpl;
import com.atlassian.bamboo.chains.branches.MergeResultState;
import com.atlassian.bamboo.chains.branches.MergeResultSummary;
import com.atlassian.bamboo.chains.branches.MergeResultSummaryImpl;
import com.atlassian.bamboo.labels.Label;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.stream.AbstractResultSummaryMapper;
import com.atlassian.bamboo.migration.stream.BuildResultWarningSummaryMapper;
import com.atlassian.bamboo.migration.stream.MapperExportException;
import com.atlassian.bamboo.migration.stream.build.ChainStageResultMapper;
import com.atlassian.bamboo.migration.stream.build.StageVariableContextMapper;
import com.atlassian.bamboo.migration.utils.BuildResultKeyHolder;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.branch.BranchIntegrationStrategy;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryDao;
import com.atlassian.bamboo.resultsummary.ResultDataRead;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.variable.StageVariableContext;
import com.atlassian.bamboo.variable.baseline.VariableContextBaselineDao;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.ReplicationMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.transaction.support.TransactionOperations;

@ListMapper(rootNodeName="results", itemNodeName="result")
public class ChainResultMapper
extends AbstractResultSummaryMapper<ChainResultsSummary> {
    private static final Logger log = Logger.getLogger(ChainResultMapper.class);
    static final String CHAIN_STAGE_RESULT_ROOT = "stageResults";
    static final String CHAIN_STAGE_RESULT_NODE = "stageResult";
    static final String CHAIN_STAGE_COMPLETE_RESULT_ROOT = "completeStageResults";
    private static final String BUILDSUMMARY_XML_LABELS = "labellings";
    static final String STAGE_XML_NAME = "name";
    static final String STAGE_XML_DESCRIPTION = "description";
    static final String STAGE_XML_IS_MANUAL = "isManual";
    static final String STAGE_XML_BUILDS_ROOT = "builds";
    static final String STAGE_XML_BUILDS_NODE = "build";
    static final String STAGE_XML_BUILD_KEY_NODE = "buildKey";
    static final String STAGE_XML_BUILD_NUMBER_NODE = "buildNumber";
    static final String STAGE_XML_PROCESSING_TIME = "processingTime";
    static final String MERGE_RESULT_NODE = "mergeResult";
    static final String MERGE_RESULT_MERGE_STATE = "mergeState";
    static final String MERGE_RESULT_PUSH_STATE = "pushState";
    static final String MERGE_RESULT_FAILURE_REASON = "failureReason";
    static final String MERGE_RESULT_INTEGRATION_REPOSITORY_ID = "integrationRepositoryId";
    static final String MERGE_RESULT_INTEGRATION_BRANCH_VCS_KEY = "integrationBranchVcsKey";
    static final String MERGE_RESULT_BRANCH_TARGET_VCS_KEY = "branchTargetVcsKey";
    static final String MERGE_RESULT_VCS_KEY = "mergeResultVcsKey";
    static final String MERGE_RESULT_INTEGRATION_STRATEGY = "integrationStrategy";
    static final String MERGE_RESULT_INTEGRATION_BRANCH_NAME = "integrationBranchName";
    static final String MERGE_RESULT_BRANCH_NAME = "branchName";
    static final String BUILDSUMMARY_XML_IS_CONTINUABLE = "continuable";
    static final String BUILDSUMMARY_XML_FIXED_IN = "fixedIn";
    static final String BUILDSUMMARY_SPECS_RESULT = "specsResult";
    private final ResultsSummaryManager resultsSummaryManager;
    private final Chain chain;

    protected ChainResultMapper(SessionFactory sessionFactory, Chain chain, BuildResultsSummaryDao buildResultsSummaryDao, VariableContextBaselineDao variableContextBaselineDao, BuildResultWarningSummaryMapper warningSummaryMapper, ResultsSummaryManager resultsSummaryManager, Map<Long, Label> labelMap, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, buildResultsSummaryDao, variableContextBaselineDao, warningSummaryMapper, (Plan)chain, chain.getProject(), labelMap, transactionOperations);
        this.chain = chain;
        this.resultsSummaryManager = resultsSummaryManager;
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull ChainResultsSummary chainResult, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        if (!exportDetailsBean.isExportResults()) {
            log.info((Object)("isExportResults is false. Not exporting " + chainResult.getPlanResultKey()));
            return;
        }
        super.exportProperties(outputElement, chainResult, session, exportDetailsBean);
        Integer fixedInResult = chainResult.getFixedInResult();
        new SMOutputElementAppender(outputElement).append("markedForDeletion", chainResult.isMarkedForDeletion()).append(BUILDSUMMARY_XML_IS_CONTINUABLE, chainResult.isContinuable()).appendIfNotNull(BUILDSUMMARY_XML_FIXED_IN, fixedInResult).append(BUILDSUMMARY_SPECS_RESULT, chainResult.isSpecsResult());
        ChainStageResultMapper mapper = new ChainStageResultMapper(this.getSessionFactory(), chainResult, this.buildResultsSummaryDao, this.buildResultWarningSummaryMapper, this.variableContextBaselineDao, this.chain, this.labelMap, this.transactionOperations);
        mapper.exportListXml(outputElement, chainResult.getStageResults(), exportDetailsBean);
        MergeResultSummary mergeResult = chainResult.getMergeResult();
        if (mergeResult != null) {
            ChainMergeResultMapper mergeResultMapper = new ChainMergeResultMapper(this.getSessionFactory(), this.transactionOperations);
            mergeResultMapper.exportXml(session, outputElement, mergeResult, exportDetailsBean);
        }
    }

    @Override
    protected void importProperties(@NotNull ChainResultsSummary chainResult, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        String elementLocalName = inputCursor.getLocalName();
        super.importProperties(chainResult, inputCursor, session);
        if (CHAIN_STAGE_RESULT_ROOT.equals(elementLocalName)) {
            session.replicate((Object)chainResult, ReplicationMode.OVERWRITE);
            LegacyChainStageResultMapper mapper = new LegacyChainStageResultMapper(this.getSessionFactory(), chainResult, this.transactionOperations);
            mapper.importListXml(inputCursor);
        } else if (CHAIN_STAGE_COMPLETE_RESULT_ROOT.equals(elementLocalName)) {
            session.replicate((Object)chainResult, ReplicationMode.OVERWRITE);
            ChainStageResultMapper mapper = new ChainStageResultMapper(this.getSessionFactory(), chainResult, this.buildResultsSummaryDao, this.buildResultWarningSummaryMapper, this.variableContextBaselineDao, this.chain, this.labelMap, this.transactionOperations);
            mapper.importListXml(inputCursor);
            this.getLabels().addAll(mapper.getLabels());
        } else if ("markedForDeletion".equals(elementLocalName)) {
            chainResult.setMarkedForDeletion(inputCursor.getElemBooleanValue(false));
        } else if (BUILDSUMMARY_XML_IS_CONTINUABLE.equals(elementLocalName)) {
            chainResult.setContinuable(inputCursor.getElemBooleanValue(false));
        } else if (BUILDSUMMARY_XML_FIXED_IN.equals(elementLocalName)) {
            int elemStringValue = inputCursor.getElemIntValue(-1);
            if (elemStringValue > 0) {
                chainResult.setFixedInResult(Integer.valueOf(elemStringValue));
            }
        } else if (MERGE_RESULT_NODE.equals(elementLocalName)) {
            ChainMergeResultMapper mapper = new ChainMergeResultMapper(this.getSessionFactory(), this.transactionOperations);
            MergeResultSummary mergeResultSummary = (MergeResultSummary)mapper.importXml(session, inputCursor);
            session.replicate((Object)mergeResultSummary, ReplicationMode.OVERWRITE);
            chainResult.setMergeResult(mergeResultSummary);
        } else if (BUILDSUMMARY_SPECS_RESULT.equals(elementLocalName)) {
            chainResult.setSpecsResult(inputCursor.getElemBooleanValue(false));
        }
    }

    @Override
    public <E extends ChainResultsSummary> void exportListXml(@NotNull Session session, @NotNull SMOutputElement outputElement, @NotNull Iterable<E> iterable, final ExportDetailsBean exportDetailsBean) throws Exception {
        final SMOutputElement rootElement = this.createListRootElement(outputElement);
        this.buildResultsSummaryDao.scrollResultSummaries(this.chain.getKey(), ResultDataRead.LAZY, (Consumer)new Consumer<ResultsSummary>(){
            private long index = 0L;

            @Override
            public void accept(@Nullable ResultsSummary resultsSummary) {
                if (resultsSummary != null) {
                    try {
                        ChainResultMapper.this.exportXml(rootElement, (ChainResultsSummary)resultsSummary, exportDetailsBean);
                        ++this.index;
                        if (this.index % 1000L == 0L) {
                            log.info((Object)String.format("Exporting %s ResultsSummaries: %d", resultsSummary.getPlanKey(), this.index));
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("Could not export " + resultsSummary), (Throwable)e);
                        throw new MapperExportException(e);
                    }
                }
            }
        });
    }

    @Override
    @NotNull
    protected ChainResultsSummary createItemInstance(SMInputCursor inputCursor) throws Exception {
        ChainResultsSummaryImpl chainResult = new ChainResultsSummaryImpl();
        chainResult.setBuildKey(this.chain.getKey());
        chainResult.setFormatVersion(1);
        return chainResult;
    }

    private class ChainMergeResultMapper
    extends BambooStAXMappingHelperAbstractImpl<MergeResultSummary, MergeResultSummary> {
        protected ChainMergeResultMapper(@NotNull SessionFactory sessionFactory, TransactionOperations transactionOperations) {
            super(sessionFactory, transactionOperations);
        }

        @Override
        @NotNull
        public String getXmlRootNodeName() {
            return ChainResultMapper.MERGE_RESULT_NODE;
        }

        @Override
        protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull MergeResultSummary object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
            super.exportProperties(outputElement, object, session, exportDetailsBean);
            new SMOutputElementAppender(outputElement).appendIfNotNull(ChainResultMapper.MERGE_RESULT_MERGE_STATE, object.getMergeState()).appendIfNotNull(ChainResultMapper.MERGE_RESULT_PUSH_STATE, object.getPushState()).appendIfNotNull(ChainResultMapper.MERGE_RESULT_INTEGRATION_STRATEGY, object.getIntegrationStrategy()).appendIfNotBlank(ChainResultMapper.MERGE_RESULT_BRANCH_TARGET_VCS_KEY, object.getBranchTargetVcsKey()).appendIfNotBlank(ChainResultMapper.MERGE_RESULT_FAILURE_REASON, object.getFailureReason()).append(ChainResultMapper.MERGE_RESULT_INTEGRATION_REPOSITORY_ID, object.getIntegrationRepositoryId()).append(ChainResultMapper.MERGE_RESULT_INTEGRATION_BRANCH_VCS_KEY, object.getIntegrationBranchVcsKey()).appendIfNotBlank(ChainResultMapper.MERGE_RESULT_VCS_KEY, object.getMergeResultVcsKey()).appendIfNotBlank(ChainResultMapper.MERGE_RESULT_INTEGRATION_BRANCH_NAME, object.getIntegrationRepositoryBranchName()).appendIfNotBlank(ChainResultMapper.MERGE_RESULT_BRANCH_NAME, object.getBranchName());
        }

        @Override
        protected void importProperties(@NotNull MergeResultSummary mergeResult, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
            super.importProperties(mergeResult, inputCursor, session);
            String elementLocalName = inputCursor.getLocalName();
            if (ChainResultMapper.MERGE_RESULT_BRANCH_TARGET_VCS_KEY.equals(elementLocalName)) {
                mergeResult.setBranchTargetVcsKey(inputCursor.getElemStringValue());
            } else if (ChainResultMapper.MERGE_RESULT_FAILURE_REASON.equals(elementLocalName)) {
                mergeResult.setFailureReason(inputCursor.getElemStringValue());
            } else if (ChainResultMapper.MERGE_RESULT_INTEGRATION_REPOSITORY_ID.equals(elementLocalName)) {
                mergeResult.setIntegrationRepositoryId(inputCursor.getElemLongValue());
            } else if (ChainResultMapper.MERGE_RESULT_INTEGRATION_BRANCH_VCS_KEY.equals(elementLocalName)) {
                mergeResult.setIntegrationBranchVcsKey(inputCursor.getElemStringValue());
            } else if (ChainResultMapper.MERGE_RESULT_VCS_KEY.equals(elementLocalName)) {
                mergeResult.setMergeResultVcsKey(inputCursor.getElemStringValue());
            } else if (ChainResultMapper.MERGE_RESULT_MERGE_STATE.equals(elementLocalName)) {
                mergeResult.setMergeState((MergeResultState)inputCursor.getElemEnumValue(MergeResultState.class));
            } else if (ChainResultMapper.MERGE_RESULT_PUSH_STATE.equals(elementLocalName)) {
                mergeResult.setPushState((MergeResultState)inputCursor.getElemEnumValue(MergeResultState.class));
            } else if (ChainResultMapper.MERGE_RESULT_INTEGRATION_STRATEGY.equals(elementLocalName)) {
                mergeResult.setIntegrationStrategy((BranchIntegrationStrategy)inputCursor.getElemEnumValue(BranchIntegrationStrategy.class));
            } else if (ChainResultMapper.MERGE_RESULT_INTEGRATION_BRANCH_NAME.equals(elementLocalName)) {
                mergeResult.setIntegrationRepositoryBranchName(inputCursor.getElemStringValue());
            } else if (ChainResultMapper.MERGE_RESULT_BRANCH_NAME.equals(elementLocalName)) {
                mergeResult.setBranchName(inputCursor.getElemStringValue());
            }
        }

        @Override
        @NotNull
        protected MergeResultSummary createItemInstance(SMInputCursor inputCursor) throws Exception {
            MergeResultSummaryImpl mergeResultSummary = new MergeResultSummaryImpl();
            return mergeResultSummary;
        }
    }

    private class LegacyChainStageResultMapper
    extends BambooStAXMappingListHelperAbstractImpl<ChainStageResult, ChainStageResult> {
        private final ChainResultsSummary chainResult;
        private final StageVariableContextMapper stageVariableContextMapper;
        private final Set<Long> alreadyReplicated;

        protected LegacyChainStageResultMapper(SessionFactory sessionFactory, @NotNull ChainResultsSummary chainResult, TransactionOperations transactionOperations) {
            super(sessionFactory, BambooStAXListImportStrategy.NO_TRANSACTION, transactionOperations);
            this.alreadyReplicated = new HashSet<Long>();
            this.stageVariableContextMapper = new StageVariableContextMapper(sessionFactory, transactionOperations);
            this.chainResult = chainResult;
        }

        @Override
        @NotNull
        public String getXmlRootNodeName() {
            return ChainResultMapper.CHAIN_STAGE_RESULT_ROOT;
        }

        @Override
        @NotNull
        public String getXmlElementNodeName() {
            return ChainResultMapper.CHAIN_STAGE_RESULT_NODE;
        }

        @Override
        protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull ChainStageResult chainStageResult, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void importProperties(@NotNull ChainStageResult stageResult, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
            super.importProperties(stageResult, inputCursor, session);
            String elementLocalName = inputCursor.getLocalName();
            if (ChainResultMapper.STAGE_XML_NAME.equals(elementLocalName)) {
                stageResult.setName(inputCursor.getElemStringValue());
            } else if (ChainResultMapper.STAGE_XML_DESCRIPTION.equals(elementLocalName)) {
                stageResult.setDescription(inputCursor.getElemStringValue());
            } else if (ChainResultMapper.STAGE_XML_IS_MANUAL.equals(elementLocalName)) {
                stageResult.setManual(inputCursor.getElemBooleanValue());
            } else if (ChainResultMapper.STAGE_XML_PROCESSING_TIME.equals(elementLocalName)) {
                stageResult.setProcessingDuration(inputCursor.getElemLongValue());
            } else if (ChainResultMapper.STAGE_XML_BUILDS_ROOT.equals(elementLocalName)) {
                ChainStageBuildResultMapper mapper = new ChainStageBuildResultMapper(this.getSessionFactory(), stageResult, this.transactionOperations);
                mapper.importListXml(inputCursor);
                this.chainResult.addStageResult(stageResult);
                session.replicate((Object)stageResult, ReplicationMode.OVERWRITE);
                this.alreadyReplicated.add(stageResult.getId());
            } else if ("manualVariables".equals(elementLocalName)) {
                List stageVariableContexts = this.stageVariableContextMapper.importListXml(inputCursor);
                if (!this.alreadyReplicated.contains(stageResult.getId())) {
                    this.chainResult.addStageResult(stageResult);
                    session.replicate((Object)stageResult, ReplicationMode.OVERWRITE);
                }
                for (StageVariableContext stageVariableContext : stageVariableContexts) {
                    stageVariableContext.setChainStageResult(stageResult);
                    session.replicate((Object)stageVariableContext, ReplicationMode.OVERWRITE);
                }
                stageResult.getManualVariablesEncrypted().addAll(stageVariableContexts);
            }
        }

        @Override
        @NotNull
        protected ChainStageResult createItemInstance(SMInputCursor inputCursor) throws Exception {
            ChainStageResultImpl stageResult = new ChainStageResultImpl();
            stageResult.setChainResult(this.chainResult);
            return stageResult;
        }
    }

    private class ChainStageBuildResultMapper
    extends BambooStAXMappingListHelperAbstractImpl<BuildResultKeyHolder, BuildResultKeyHolder> {
        private ChainStageResult stageResult;

        private ChainStageBuildResultMapper(SessionFactory sessionFactory, @NotNull ChainStageResult stageResult, TransactionOperations transactionOperations) {
            super(sessionFactory, BambooStAXListImportStrategy.NO_TRANSACTION, transactionOperations);
            this.stageResult = stageResult;
        }

        @Override
        @NotNull
        public String getXmlRootNodeName() {
            return ChainResultMapper.STAGE_XML_BUILDS_ROOT;
        }

        @Override
        @NotNull
        public String getXmlElementNodeName() {
            return ChainResultMapper.STAGE_XML_BUILDS_NODE;
        }

        @Override
        public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<BuildResultKeyHolder> buildResultKeyHolderList, @NotNull BuildResultKeyHolder planResultKeyHolder, long objectIndex, @NotNull Session session) throws Exception {
            BuildResultsSummary buildResultSummary = (BuildResultsSummary)ChainResultMapper.this.resultsSummaryManager.getResultsSummary(planResultKeyHolder.getPlanResultKey(), BuildResultsSummary.class);
            if (buildResultSummary != null) {
                this.stageResult.addBuildResult(buildResultSummary);
            }
        }

        @Override
        protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull BuildResultKeyHolder object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void importProperties(@NotNull BuildResultKeyHolder object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
            String elementLocalName = inputCursor.getLocalName();
            if (ChainResultMapper.STAGE_XML_BUILD_KEY_NODE.equals(elementLocalName)) {
                object.setBuildKey(inputCursor.getElemStringValue());
            } else if (ChainResultMapper.STAGE_XML_BUILD_NUMBER_NODE.equals(elementLocalName)) {
                object.setBuildNumber(inputCursor.getElemIntValue());
            }
        }

        @Override
        @NotNull
        protected BuildResultKeyHolder createItemInstance(SMInputCursor inputCursor) throws Exception {
            return new BuildResultKeyHolder();
        }
    }
}

