/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream.build;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainStage;
import com.atlassian.bamboo.chains.ChainStageImpl;
import com.atlassian.bamboo.deletion.Deletable;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.stream.build.ChainBuildMapper;
import com.atlassian.bamboo.migration.utils.BuildKeyHolder;
import com.atlassian.bamboo.migration.utils.DeletableInterfaceMapper;
import com.atlassian.bamboo.plan.PlanDao;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

public class ChainStageMapper
extends BambooStAXMappingListHelperAbstractImpl<ChainStage, ChainStage> {
    private static final Logger log = Logger.getLogger(ChainStageMapper.class);
    private static final String STAGE_XML_ROOT = "stages";
    private static final String STAGE_XML_NODE = "stage";
    private static final String STAGE_XML_NAME = "name";
    private static final String STAGE_XML_DESCRIPTION = "description";
    private static final String STAGE_XML_IS_MANUAL = "isManual";
    private static final String STAGE_XML_IS_FINAL = "isFinal";
    private static final String STAGE_XML_BUILDS_ROOT = "builds";
    private final Chain chain;
    private final PlanDao planDao;

    protected ChainStageMapper(SessionFactory sessionFactory, @NotNull Chain chain, PlanDao planDao, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.NO_TRANSACTION, transactionOperations);
        this.chain = chain;
        this.planDao = planDao;
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return STAGE_XML_ROOT;
    }

    @Override
    @NotNull
    public String getXmlElementNodeName() {
        return STAGE_XML_NODE;
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<ChainStage> chainStages, @NotNull ChainStage stage, long objectIndex, @NotNull Session session) throws Exception {
        this.chain.addStage(stage);
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull ChainStage stage, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, stage, session, exportDetailsBean);
        SMOutputElementAppender appender = new SMOutputElementAppender(outputElement).append(STAGE_XML_NAME, stage.getName()).appendIfNotBlank(STAGE_XML_DESCRIPTION, stage.getDescription());
        if (stage.isManual()) {
            appender.append(STAGE_XML_IS_MANUAL, true);
        }
        if (stage.isFinal()) {
            appender.append(STAGE_XML_IS_FINAL, true);
        }
        DeletableInterfaceMapper.exportProperties(appender, (Deletable)stage);
        ChainBuildMapper mapper = new ChainBuildMapper(this.getSessionFactory(), stage, this.planDao, this.transactionOperations);
        mapper.exportListXml(outputElement, Collections2.transform((Collection)stage.getJobs(), (Function)new Function<Job, BuildKeyHolder>(){

            public BuildKeyHolder apply(Job from) {
                return new BuildKeyHolder(from.getKey());
            }
        }), exportDetailsBean);
    }

    @Override
    protected void importProperties(@NotNull ChainStage stage, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(stage, inputCursor, session);
        String elementLocalName = inputCursor.getLocalName();
        if (STAGE_XML_NAME.equals(elementLocalName)) {
            stage.setName(inputCursor.getElemStringValue());
        } else if (STAGE_XML_DESCRIPTION.equals(elementLocalName)) {
            stage.setDescription(inputCursor.getElemStringValue());
        } else if (STAGE_XML_IS_MANUAL.equals(elementLocalName)) {
            stage.setManual(inputCursor.getElemBooleanValue());
        } else if (STAGE_XML_IS_FINAL.equals(elementLocalName)) {
            stage.setFinal(inputCursor.getElemBooleanValue());
        } else if (STAGE_XML_BUILDS_ROOT.equals(elementLocalName)) {
            ChainBuildMapper mapper = new ChainBuildMapper(this.getSessionFactory(), stage, this.planDao, this.transactionOperations);
            mapper.importListXml(inputCursor);
        } else if (DeletableInterfaceMapper.isApplicable(elementLocalName)) {
            DeletableInterfaceMapper.importProperties((Deletable)stage, inputCursor);
        }
    }

    @Override
    @NotNull
    protected ChainStage createItemInstance(SMInputCursor inputCursor) throws Exception {
        ChainStageImpl chainStage = new ChainStageImpl();
        chainStage.setChain(this.chain);
        return chainStage;
    }
}

