/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream.build;

import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.chains.ChainStageResultImpl;
import com.atlassian.bamboo.labels.Label;
import com.atlassian.bamboo.labels.Labelling;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.stream.BuildResultSummaryMapper;
import com.atlassian.bamboo.migration.stream.BuildResultWarningSummaryMapper;
import com.atlassian.bamboo.migration.stream.build.StageVariableContextMapper;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryDao;
import com.atlassian.bamboo.variable.StageVariableContext;
import com.atlassian.bamboo.variable.baseline.VariableContextBaselineDao;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.ReplicationMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

public class ChainStageResultMapper
extends BambooStAXMappingListHelperAbstractImpl<ChainStageResult, ChainStageResult> {
    static final String CHAIN_STAGE_RESULT_NODE = "stageResult";
    static final String STAGE_XML_NAME = "name";
    static final String STAGE_XML_DESCRIPTION = "description";
    static final String STAGE_XML_IS_MANUAL = "isManual";
    static final String STAGE_XML_BUILDS_ROOT = "builds";
    static final String STAGE_XML_BUILDS_NODE = "build";
    static final String STAGE_XML_BUILD_KEY_NODE = "buildKey";
    static final String STAGE_XML_BUILD_NUMBER_NODE = "buildNumber";
    static final String STAGE_XML_PROCESSING_TIME = "processingTime";
    private final ChainResultsSummary chainResult;
    private final StageVariableContextMapper stageVariableContextMapper;
    private final BuildResultsSummaryDao buildResultsSummaryDao;
    private final BuildResultWarningSummaryMapper warningSummaryMapper;
    private final VariableContextBaselineDao variableContextBaselineDao;
    private final Set<Long> alreadyReplicated = new HashSet<Long>();
    private final Chain chain;
    private final Map<Long, Label> labelMap;
    private final List<Labelling> labels;

    public ChainStageResultMapper(SessionFactory sessionFactory, ChainResultsSummary chainResult, BuildResultsSummaryDao buildResultsSummaryDao, BuildResultWarningSummaryMapper warningSummaryMapper, VariableContextBaselineDao variableContextBaselineDao, Chain chain, Map<Long, Label> labelMap, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.NO_TRANSACTION, transactionOperations);
        this.stageVariableContextMapper = new StageVariableContextMapper(sessionFactory, transactionOperations);
        this.chainResult = chainResult;
        this.buildResultsSummaryDao = buildResultsSummaryDao;
        this.warningSummaryMapper = warningSummaryMapper;
        this.variableContextBaselineDao = variableContextBaselineDao;
        this.chain = chain;
        this.labelMap = labelMap;
        this.labels = new ArrayList<Labelling>();
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return "completeStageResults";
    }

    @Override
    @NotNull
    public String getXmlElementNodeName() {
        return CHAIN_STAGE_RESULT_NODE;
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull ChainStageResult chainStageResult, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, chainStageResult, session, exportDetailsBean);
        SMOutputElementAppender appender = new SMOutputElementAppender(outputElement).append(STAGE_XML_NAME, chainStageResult.getName()).appendIfNotBlank(STAGE_XML_DESCRIPTION, chainStageResult.getDescription()).append(STAGE_XML_PROCESSING_TIME, chainStageResult.getProcessingDuration());
        if (chainStageResult.isManual()) {
            appender.append(STAGE_XML_IS_MANUAL, true);
        }
        BuildResultSummaryMapper mapper = new BuildResultSummaryMapper(this.getSessionFactory(), this.buildResultsSummaryDao, this.variableContextBaselineDao, this.warningSummaryMapper, this.chain.getProject(), this.labelMap, this.transactionOperations, this.chainResult, chainStageResult.getId());
        mapper.exportListXml(outputElement, chainStageResult.getBuildResults(), exportDetailsBean);
        this.stageVariableContextMapper.exportListXml(outputElement, chainStageResult.getManualVariablesEncrypted(), exportDetailsBean);
    }

    @Override
    protected void importProperties(@NotNull ChainStageResult stageResult, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(stageResult, inputCursor, session);
        String elementLocalName = inputCursor.getLocalName();
        if (STAGE_XML_NAME.equals(elementLocalName)) {
            stageResult.setName(inputCursor.getElemStringValue());
        } else if (STAGE_XML_DESCRIPTION.equals(elementLocalName)) {
            stageResult.setDescription(inputCursor.getElemStringValue());
        } else if (STAGE_XML_IS_MANUAL.equals(elementLocalName)) {
            stageResult.setManual(inputCursor.getElemBooleanValue());
        } else if (STAGE_XML_PROCESSING_TIME.equals(elementLocalName)) {
            stageResult.setProcessingDuration(inputCursor.getElemLongValue());
        } else if ("buildResultSummaries".equals(elementLocalName)) {
            this.chainResult.addStageResult(stageResult);
            session.replicate((Object)stageResult, ReplicationMode.OVERWRITE);
            BuildResultSummaryMapper mapper = new BuildResultSummaryMapper(this.getSessionFactory(), this.buildResultsSummaryDao, this.variableContextBaselineDao, this.warningSummaryMapper, this.chain.getProject(), this.labelMap, this.transactionOperations, this.chainResult, stageResult.getId());
            List jobResults = mapper.importListXml(inputCursor);
            this.labels.addAll(mapper.getLabels());
            this.alreadyReplicated.add(stageResult.getId());
        } else if ("manualVariables".equals(elementLocalName)) {
            List stageVariableContexts = this.stageVariableContextMapper.importListXml(inputCursor);
            if (!this.alreadyReplicated.contains(stageResult.getId())) {
                this.chainResult.addStageResult(stageResult);
                session.replicate((Object)stageResult, ReplicationMode.OVERWRITE);
            }
            for (StageVariableContext stageVariableContext : stageVariableContexts) {
                stageVariableContext.setChainStageResult(stageResult);
                session.replicate((Object)stageVariableContext, ReplicationMode.OVERWRITE);
            }
            stageResult.getManualVariablesEncrypted().addAll(stageVariableContexts);
        }
    }

    @Override
    @NotNull
    protected ChainStageResult createItemInstance(SMInputCursor inputCursor) throws Exception {
        ChainStageResultImpl stageResult = new ChainStageResultImpl();
        stageResult.setChainResult(this.chainResult);
        return stageResult;
    }

    public List<Labelling> getLabels() {
        return this.labels;
    }
}

