/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream.build;

import com.atlassian.bamboo.author.ExtendedAuthor;
import com.atlassian.bamboo.build.DefaultJob;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.labels.Label;
import com.atlassian.bamboo.labels.Labelling;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.MapperUtil;
import com.atlassian.bamboo.migration.stream.AbstractPlanMapper;
import com.atlassian.bamboo.migration.stream.BuildResultSummaryMapper;
import com.atlassian.bamboo.migration.stream.BuildResultWarningSummaryMapper;
import com.atlassian.bamboo.migration.stream.notifications.NotificationSetMapper;
import com.atlassian.bamboo.migration.stream.requirements.RequirementSetMapper;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanDao;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionHistoryStandaloneDao;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.repository.PlanRepositoryLinkDao;
import com.atlassian.bamboo.repository.RepositoryDefinitionDao;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryDao;
import com.atlassian.bamboo.resultsummary.warning.BuildResultWarningSummaryDao;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementSet;
import com.atlassian.bamboo.variable.baseline.VariableContextBaselineDao;
import java.util.List;
import java.util.Map;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.ReplicationMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ListMapper(rootNodeName="subplans", itemNodeName="subplan")
public class JobMapper
extends AbstractPlanMapper<Job> {
    static final String XML_ROOT = "subplans";
    private final SessionFactory sessionFactory;
    private final BuildResultsSummaryDao buildResultsSummaryDao;
    private final RequirementSetMapper requirementSetMapper;
    private final BuildResultWarningSummaryDao buildResultWarningSummaryDao;
    private final VariableContextBaselineDao variableContextBaselineDao;

    public JobMapper(@NotNull SessionFactory sessionFactory, @NotNull Project project, @NotNull Map<Long, Label> labelMap, @NotNull Map<Long, ExtendedAuthor> authorMap, @NotNull BuildResultsSummaryDao buildResultsSummaryDao, BuildResultWarningSummaryDao buildResultWarningSummaryDao, @NotNull PlanVcsRevisionHistoryStandaloneDao planVcsRevisionHistoryDao, @NotNull PlanDao planDao, @NotNull VariableContextBaselineDao variableContextBaselineDao, @NotNull RepositoryDefinitionDao repositoryDefinitionDao, @NotNull PlanRepositoryLinkDao planRepositoryLinkDao, @NotNull NotificationSetMapper notificationSetMapper, @NotNull RequirementSetMapper requirementSetMapper, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_ITEM_AND_CLEAR_SESSION_TRANSACTION, project, labelMap, authorMap, planVcsRevisionHistoryDao, planDao, repositoryDefinitionDao, planRepositoryLinkDao, notificationSetMapper, transactionOperations);
        this.sessionFactory = sessionFactory;
        this.buildResultsSummaryDao = buildResultsSummaryDao;
        this.buildResultWarningSummaryDao = buildResultWarningSummaryDao;
        this.requirementSetMapper = requirementSetMapper;
        this.variableContextBaselineDao = variableContextBaselineDao;
    }

    @Override
    public Job createPlanEntity() {
        return new DefaultJob();
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull Job job, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, job, session, exportDetailsBean);
        this.requirementSetMapper.exportXml(session, outputElement, job.getRequirementSet(), exportDetailsBean);
    }

    @Override
    protected void importProperties(@NotNull Job job, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        String elementLocalName = inputCursor.getLocalName();
        super.importProperties(job, inputCursor, session);
        if (MapperUtil.matchesElement(this.requirementSetMapper, elementLocalName)) {
            job.setRequirementSet((RequirementSet)this.requirementSetMapper.importXml(session, inputCursor));
        } else if ("buildResultSummaries".equals(elementLocalName)) {
            BuildResultWarningSummaryMapper warningSummaryMapper = new BuildResultWarningSummaryMapper(this.sessionFactory, this.buildResultWarningSummaryDao, this.transactionOperations);
            BuildResultSummaryMapper mapper = new BuildResultSummaryMapper(this.sessionFactory, this.buildResultsSummaryDao, this.variableContextBaselineDao, warningSummaryMapper, (Plan)job, job.getProject(), this.labelMap, this.transactionOperations);
            mapper.importListXml(inputCursor);
            this.labels.addAll(mapper.getLabels());
        }
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<Job> plans, @NotNull Job job, long objectIndex, @NotNull Session session) throws Exception {
        RequirementSet requirementSet = job.getRequirementSet();
        if (requirementSet != null) {
            session.saveOrUpdate((Object)requirementSet);
        }
        session.replicate((Object)job.getProject(), ReplicationMode.OVERWRITE);
        session.replicate((Object)job, ReplicationMode.OVERWRITE);
        for (Labelling label : this.labels) {
            session.replicate((Object)label, ReplicationMode.OVERWRITE);
        }
        if (this.planBuildNumbers != null) {
            this.planBuildNumbers.setPlanId(job.getId());
            session.save((Object)this.planBuildNumbers);
        }
    }
}

