/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream.build;

import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.stream.MapperExportException;
import com.atlassian.bamboo.plan.rss.PlanVcsBambooSpecsSourceDto;
import com.atlassian.bamboo.plan.rss.PlanVcsBambooSpecsSourceDtoImpl;
import com.atlassian.bamboo.specs.BambooSpecsSourceDao;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.ReplicationMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ListMapper(rootNodeName="planSpecsStates", itemNodeName="planSpecsState")
public class PlanSpecsSourceMapper
extends BambooStAXMappingListHelperAbstractImpl<PlanVcsBambooSpecsSourceDto, PlanVcsBambooSpecsSourceDto>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(PlanSpecsSourceMapper.class);
    private static final String XML_PLAN_ID = "planId";
    private static final String XML_SPECS_STATE_ID = "specsStateId";
    private final BambooSpecsSourceDao specsSourceDao;

    public PlanSpecsSourceMapper(SessionFactory sessionFactory, BambooSpecsSourceDao specsSourceDao, TransactionOperations transactionOperations) {
        super(sessionFactory, transactionOperations);
        this.specsSourceDao = specsSourceDao;
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        SMOutputElement rootElement = this.createListRootElement(outputElement);
        this.specsSourceDao.scrollPlanVcsBambooSpecsSourceForExport(specsSource -> {
            try {
                this.exportXml(rootElement, specsSource, exportDetailsBean);
            }
            catch (Exception e) {
                log.error((Object)("Could not export PlanVcsBambooSpecsSourceDto " + e));
                throw new MapperExportException(e);
            }
        });
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull PlanVcsBambooSpecsSourceDto specsSource, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, specsSource, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).append(XML_PLAN_ID, specsSource.getPlanId()).append(XML_SPECS_STATE_ID, specsSource.getVcsBambooSpecsSourceId());
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        this.importListXmlInTransaction(inputCursor);
    }

    @Override
    @NotNull
    protected PlanVcsBambooSpecsSourceDto createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new PlanVcsBambooSpecsSourceDtoImpl();
    }

    @Override
    protected void importProperties(@NotNull PlanVcsBambooSpecsSourceDto specsSource, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(specsSource, inputCursor, session);
        String elementLocalName = inputCursor.getLocalName();
        if (XML_PLAN_ID.equals(elementLocalName)) {
            specsSource.setPlanId(inputCursor.getElemLongValue());
        } else if (XML_SPECS_STATE_ID.equals(elementLocalName)) {
            specsSource.setVcsBambooSpecsSourceId(inputCursor.getElemLongValue());
        }
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<PlanVcsBambooSpecsSourceDto> list, @NotNull PlanVcsBambooSpecsSourceDto object, long objectIndex, @NotNull Session session) throws Exception {
        super.afterImportListItem(inputCursor, list, object, objectIndex, session);
        session.replicate((Object)object, ReplicationMode.OVERWRITE);
    }
}

