/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream.build;

import com.atlassian.bamboo.author.AuthorDao;
import com.atlassian.bamboo.labels.LabelDao;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.beans.MapperFactory;
import com.atlassian.bamboo.migration.stream.AbstractProjectMapper;
import com.atlassian.bamboo.migration.stream.build.ChainBranchMapper;
import com.atlassian.bamboo.migration.stream.build.ChainMapper;
import com.atlassian.bamboo.migration.stream.build.JobMapper;
import com.atlassian.bamboo.plan.PlanDao;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionHistoryStandaloneDao;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectDao;
import com.atlassian.bamboo.repository.PlanRepositoryLinkDao;
import com.atlassian.bamboo.repository.RepositoryDefinitionDao;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

public class ProjectChainMapper
extends AbstractProjectMapper {
    private static final Logger log = Logger.getLogger(ProjectChainMapper.class);
    private final MapperFactory mapperFactory;

    public ProjectChainMapper(SessionFactory sessionFactory, @NotNull ProjectDao projectDao, AuthorDao authorDao, LabelDao labelDao, @NotNull PlanDao planDao, PlanVcsRevisionHistoryStandaloneDao planVcsRevisionHistoryDao, @NotNull RepositoryDefinitionDao repositoryDefinitionDao, @NotNull PlanRepositoryLinkDao planRepositoryLinkDao, @NotNull MapperFactory mapperFactory, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_TRANSACTION, projectDao, authorDao, labelDao, planDao, planVcsRevisionHistoryDao, repositoryDefinitionDao, planRepositoryLinkDao, transactionOperations);
        this.mapperFactory = mapperFactory;
    }

    @Override
    protected void importProperties(@NotNull Project project, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        String elementLocalName = inputCursor.getLocalName();
        super.importProperties(project, inputCursor, session);
        if ("subplans".equals(elementLocalName)) {
            JobMapper mapper = this.mapperFactory.newJobMapper(project, this.labelMap, this.authorMap, this.transactionOperations);
            mapper.importListXml(inputCursor);
        } else if ("chains".equals(elementLocalName)) {
            ChainMapper mapper = this.mapperFactory.newChainMapper(project, this.labelMap, this.authorMap, this.transactionOperations);
            mapper.importListXml(inputCursor);
        } else if ("branches".equals(elementLocalName)) {
            ChainBranchMapper mapper = this.mapperFactory.newChainBranchMapper(project, this.labelMap, this.authorMap, this.transactionOperations);
            mapper.importListXml(inputCursor);
        }
    }
}

