/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream.build;

import com.atlassian.bamboo.build.PlanDependency;
import com.atlassian.bamboo.build.PlanDependencyImpl;
import com.atlassian.bamboo.build.PlanDependencyManager;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.stream.build.AbstractProjectDependencyMapper;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanDao;
import java.util.Set;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

public class ProjectDependencyMapper
extends AbstractProjectDependencyMapper {
    private static final Logger log = Logger.getLogger(ProjectDependencyMapper.class);
    private static final String DEPENDENCY_TYPE_XML_NODE = "type";

    public ProjectDependencyMapper(SessionFactory sessionFactory, PlanDao planDao, PlanDependencyManager planDependencyManager, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, planDao, planDependencyManager, transactionOperations);
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return "dependencies";
    }

    @Override
    @NotNull
    public String getXmlElementNodeName() {
        return "dependency";
    }

    @Override
    protected void importProperties(@NotNull PlanDependency object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        String elementLocalName = inputCursor.getLocalName();
        PlanDependencyImpl dependency = (PlanDependencyImpl)object;
        if ("parent".equals(elementLocalName)) {
            String parentKey = inputCursor.getElemStringValue();
            dependency.setParentPlan(this.planDao.getPlanByKey(parentKey, Plan.class));
        } else if ("child".equals(elementLocalName)) {
            String childKey = inputCursor.getElemStringValue();
            dependency.setChildPlan(this.planDao.getPlanByKey(childKey, Plan.class));
        } else if (DEPENDENCY_TYPE_XML_NODE.equals(elementLocalName)) {
            dependency.setDependencyType(inputCursor.getElemStringValue());
        }
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull PlanDependency object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, object, session, exportDetailsBean);
        SMOutputElementAppender outputter = new SMOutputElementAppender(outputElement).append(DEPENDENCY_TYPE_XML_NODE, object.getDependencyType());
        Plan parentPlan = object.getParentPlan();
        Plan childPlan = object.getChildPlan();
        if (parentPlan != null) {
            outputter.append("parent", parentPlan.getKey());
        }
        if (childPlan != null) {
            outputter.append("child", childPlan.getKey());
        }
    }

    @Override
    @NotNull
    protected PlanDependency createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new PlanDependencyImpl();
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        Set dependencies = this.planDependencyManager.getAllDependencies();
        this.exportListXml(outputElement, dependencies, exportDetailsBean);
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        this.importListXml(inputCursor);
    }
}

