/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream.build;

import com.atlassian.bamboo.author.AuthorDao;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainStage;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.labels.LabelDao;
import com.atlassian.bamboo.labels.Labelling;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.beans.MapperFactory;
import com.atlassian.bamboo.migration.stream.AbstractProjectMapper;
import com.atlassian.bamboo.migration.stream.LabellingMapper;
import com.atlassian.bamboo.migration.stream.build.ChainBranchMapper;
import com.atlassian.bamboo.migration.stream.build.ChainMapper;
import com.atlassian.bamboo.migration.stream.build.JobMapper;
import com.atlassian.bamboo.migration.stream.build.RssProjectPermissionsMapper;
import com.atlassian.bamboo.plan.PlanDao;
import com.atlassian.bamboo.plan.PlanPredicates;
import com.atlassian.bamboo.plan.branch.ChainBranch;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionHistoryStandaloneDao;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectDao;
import com.atlassian.bamboo.repository.PlanRepositoryLinkDao;
import com.atlassian.bamboo.repository.RepositoryDefinitionDao;
import com.atlassian.bamboo.specs.RssProjectPermission;
import com.atlassian.bamboo.specs.RssProjectPermissionDao;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.ReplicationMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

public class ProjectMapper
extends AbstractProjectMapper {
    private static final Logger log = Logger.getLogger(ProjectMapper.class);
    protected List<Labelling> labels;
    private final MapperFactory mapperFactory;
    private final RssProjectPermissionDao rssProjectPermissionDao;
    private List<RssProjectPermission> rssProjectPermissions;

    public ProjectMapper(SessionFactory sessionFactory, @NotNull ProjectDao projectDao, AuthorDao authorDao, LabelDao labelDao, PlanDao planDao, PlanVcsRevisionHistoryStandaloneDao planVcsRevisionHistoryDao, @NotNull RepositoryDefinitionDao repositoryDefinitionDao, @NotNull PlanRepositoryLinkDao planRepositoryLinkDao, RssProjectPermissionDao rssProjectPermissionDao, @NotNull MapperFactory mapperFactory, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_TRANSACTION, projectDao, authorDao, labelDao, planDao, planVcsRevisionHistoryDao, repositoryDefinitionDao, planRepositoryLinkDao, transactionOperations);
        this.mapperFactory = mapperFactory;
        this.rssProjectPermissionDao = rssProjectPermissionDao;
    }

    @Override
    protected void importProperties(@NotNull Project project, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        String elementLocalName = inputCursor.getLocalName();
        super.importProperties(project, inputCursor, session);
        if ("labellings".equals(elementLocalName)) {
            LabellingMapper mapper = new LabellingMapper(this.sessionFactory, null, null, project, this.labelMap, this.transactionOperations);
            this.labels.addAll(mapper.importListXml(inputCursor));
        } else if ("rssPermissions".equals(elementLocalName)) {
            RssProjectPermissionsMapper mapper = this.mapperFactory.newRssProjectPermissionsMapper(project, this.transactionOperations);
            this.rssProjectPermissions = mapper.importListXml(inputCursor);
        }
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull Project project, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, project, session, exportDetailsBean);
        LabellingMapper mapper = new LabellingMapper(this.sessionFactory, null, null, project, this.labelMap, this.transactionOperations);
        mapper.exportListXml(outputElement, project.getRelatedLabellings(), exportDetailsBean);
        log.info((Object)("Exporting rss repositories from project [" + project.getName() + "]"));
        RssProjectPermissionsMapper rssProjectRepositoriesMapper = this.mapperFactory.newRssProjectPermissionsMapper(project, this.transactionOperations);
        rssProjectRepositoriesMapper.exportListXml(outputElement, this.rssProjectPermissionDao.findByProjectId(project.getId()), exportDetailsBean);
        List allChains = this.planDao.findAllPlansByProject(project, Chain.class);
        Iterable masterChains = Iterables.filter((Iterable)allChains, PlanPredicates::planIsMaster);
        List chainBranches = this.planDao.findAllPlansByProject(project, ChainBranch.class);
        log.info((Object)("Exporting all jobs (master + branches) from project [" + project.getName() + "]"));
        for (Chain chain : Iterables.concat((Iterable)masterChains, (Iterable)chainBranches)) {
            for (ChainStage stage : chain.getAllStages()) {
                JobMapper jobMapper = this.mapperFactory.newJobMapper(project, this.labelMap, this.authorMap, this.transactionOperations);
                jobMapper.exportListXml(outputElement, stage.getAllJobs(), exportDetailsBean);
            }
        }
        log.info((Object)("Exporting chains from project [" + project.getName() + "]"));
        ChainMapper chainMapper = this.mapperFactory.newChainMapper(project, this.labelMap, this.authorMap, this.transactionOperations);
        chainMapper.exportListXml(outputElement, masterChains, exportDetailsBean);
        log.info((Object)("Exporting chain branches from project [" + project.getName() + "]"));
        ChainBranchMapper chainBranchMapper = this.mapperFactory.newChainBranchMapper(project, this.labelMap, this.authorMap, this.transactionOperations);
        chainBranchMapper.exportListXml(outputElement, chainBranches, exportDetailsBean);
        log.info((Object)("Completed export of project [" + project.getName() + "]"));
    }

    @Override
    @NotNull
    protected Project createItemInstance(SMInputCursor inputCursor) throws Exception {
        this.labels = new ArrayList<Labelling>();
        this.rssProjectPermissions = new ArrayList<RssProjectPermission>();
        return super.createItemInstance(inputCursor);
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<Project> projects, @NotNull Project object, long objectIndex, @NotNull Session session) throws Exception {
        this.saveBambooObject(session, (BambooIdProvider)object);
        if (!this.rssProjectPermissions.isEmpty()) {
            this.rssProjectPermissions.forEach(permission -> this.saveBambooObject(session, (BambooIdProvider)permission));
        }
        for (Labelling label : this.labels) {
            session.replicate((Object)label, ReplicationMode.OVERWRITE);
        }
    }
}

