/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream.build;

import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.stream.MapperExportException;
import com.atlassian.bamboo.plan.VcsBambooSpecsSource;
import com.atlassian.bamboo.plan.VcsBambooSpecsSourceImpl;
import com.atlassian.bamboo.plan.VcsLocationBambooSpecsStateImpl;
import com.atlassian.bamboo.specs.BambooSpecsSourceDao;
import com.atlassian.bamboo.specs.BambooSpecsStateDao;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.ReplicationMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ListMapper(rootNodeName="specsSources", itemNodeName="specsSource")
public class SpecsSourceMapper
extends BambooStAXMappingListHelperAbstractImpl<VcsBambooSpecsSource, VcsBambooSpecsSource>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(SpecsSourceMapper.class);
    private static final String XML_SOURCE_LOCATION = "sourceLocation";
    private static final String XML_SPECS_STATE_ID = "specsStateId";
    private final BambooSpecsSourceDao specsSourceDao;
    private final BambooSpecsStateDao specsStateDao;

    public SpecsSourceMapper(SessionFactory sessionFactory, BambooSpecsSourceDao specsSourceDao, BambooSpecsStateDao specsStateDao, TransactionOperations transactionOperations) {
        super(sessionFactory, transactionOperations);
        this.specsSourceDao = specsSourceDao;
        this.specsStateDao = specsStateDao;
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        SMOutputElement rootElement = this.createListRootElement(outputElement);
        this.specsSourceDao.scrollVcsBambooSpecsSourceForExport(specsSource -> {
            try {
                this.exportXml(rootElement, specsSource, exportDetailsBean);
            }
            catch (Exception e) {
                log.error((Object)("Could not export VcsBambooSpecsSource by id: " + specsSource.getId()), (Throwable)e);
                throw new MapperExportException(e);
            }
        });
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull VcsBambooSpecsSource specsSource, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        if (specsSource.getId() == null) {
            log.warn((Object)"Got VcsBambooSpecsSource with null id to export. Continue without exporting this entity.");
            return;
        }
        super.exportProperties(outputElement, specsSource, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).append("id", specsSource.getId()).appendIfNotBlank(XML_SOURCE_LOCATION, specsSource.getSourceLocation().orElse("")).append(XML_SPECS_STATE_ID, specsSource.getVcsLocationBambooSpecsState().getId());
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        this.importListXmlInTransaction(inputCursor);
    }

    @Override
    @NotNull
    protected VcsBambooSpecsSource createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new VcsBambooSpecsSourceImpl();
    }

    @Override
    protected void importProperties(@NotNull VcsBambooSpecsSource object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(object, inputCursor, session);
        VcsBambooSpecsSourceImpl specsSource = (VcsBambooSpecsSourceImpl)object;
        switch (inputCursor.getLocalName()) {
            case "id": {
                specsSource.setId(Long.valueOf(inputCursor.getElemLongValue(-1L)));
                break;
            }
            case "sourceLocation": {
                String sourceLocation = inputCursor.getElemStringValue();
                if (!StringUtils.isNotBlank((CharSequence)sourceLocation)) break;
                specsSource.setSourceLocation(sourceLocation);
                break;
            }
            case "specsStateId": {
                long specsStateId = inputCursor.getElemLongValue(-1L);
                Optional maybeSpecsState = this.specsStateDao.findById(specsStateId);
                if (maybeSpecsState.isPresent()) {
                    specsSource.setVcsLocationBambooSpecsState((VcsLocationBambooSpecsStateImpl)maybeSpecsState.get());
                    break;
                }
                log.error((Object)String.format("Can't import VcsBambooSpecsSource(id:%d) since requested VcsLocationBambooSpecsState(id:%d) doesn't exist", specsSource.getId(), specsStateId));
            }
        }
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<VcsBambooSpecsSource> list, @NotNull VcsBambooSpecsSource object, long objectIndex, @NotNull Session session) throws Exception {
        super.afterImportListItem(inputCursor, list, object, objectIndex, session);
        session.replicate((Object)object, ReplicationMode.OVERWRITE);
    }
}

