/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream.build;

import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.MapperUtil;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.stream.MapperExportException;
import com.atlassian.bamboo.plan.VcsLocationBambooSpecsState;
import com.atlassian.bamboo.plan.VcsLocationBambooSpecsStateImpl;
import com.atlassian.bamboo.specs.BambooSpecsStateDao;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.ReplicationMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ListMapper(rootNodeName="specsStates", itemNodeName="specsState")
public class SpecsStateMapper
extends BambooStAXMappingListHelperAbstractImpl<VcsLocationBambooSpecsState, VcsLocationBambooSpecsState>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(SpecsStateMapper.class);
    private static final String XML_BRANCH = "branch";
    private static final String XML_REVISION = "revision";
    private static final String XML_VCS_LOCATION = "vcsLocation";
    private static final String XML_SPECS_EXECUTION_DATE = "specsExecutionDate";
    private static final String XML_LOG_FILENAME = "logFilename";
    private static final String XML_IMPORT_STATE = "importState";
    private final BambooSpecsStateDao specsStateDao;

    public SpecsStateMapper(SessionFactory sessionFactory, BambooSpecsStateDao specsStateDao, TransactionOperations transactionOperations) {
        super(sessionFactory, transactionOperations);
        this.specsStateDao = specsStateDao;
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        SMOutputElement rootElement = this.createListRootElement(outputElement);
        this.specsStateDao.scrollVcsLocationBambooSpecsStateForExport(specsState -> {
            try {
                this.exportXml(rootElement, specsState, exportDetailsBean);
            }
            catch (Exception e) {
                log.error((Object)("Could not export VcsLocationBambooSpecsState by id: " + specsState.getId()), (Throwable)e);
                throw new MapperExportException(e);
            }
        });
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull VcsLocationBambooSpecsState specsState, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, specsState, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).append("id", specsState.getId()).append(XML_BRANCH, specsState.getBranch()).append(XML_REVISION, specsState.getRevision()).append(XML_VCS_LOCATION, specsState.getVcsLocationId()).appendIfNotNull(XML_SPECS_EXECUTION_DATE, specsState.getSpecsExecutionDate()).appendIfNotBlank(XML_LOG_FILENAME, specsState.getLogFilename()).appendIfNotNull(XML_IMPORT_STATE, specsState.getSpecImportState());
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        this.importListXmlInTransaction(inputCursor);
    }

    @Override
    @NotNull
    protected VcsLocationBambooSpecsState createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new VcsLocationBambooSpecsStateImpl();
    }

    @Override
    protected void importProperties(@NotNull VcsLocationBambooSpecsState object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(object, inputCursor, session);
        VcsLocationBambooSpecsStateImpl specsState = (VcsLocationBambooSpecsStateImpl)object;
        switch (inputCursor.getLocalName()) {
            case "id": {
                specsState.setId(Long.valueOf(inputCursor.getElemLongValue(-1L)));
                break;
            }
            case "branch": {
                specsState.setBranch(inputCursor.getElemStringValue());
                break;
            }
            case "revision": {
                specsState.setRevision(inputCursor.getElemStringValue());
                break;
            }
            case "vcsLocation": {
                specsState.setVcsLocationId(inputCursor.getElemLongValue(-1L));
                break;
            }
            case "importState": {
                specsState.setSpecsImportState(VcsLocationBambooSpecsState.SpecsImportState.valueOf((String)inputCursor.getElemStringValue()));
                break;
            }
            case "logFilename": {
                specsState.setLogFilename(inputCursor.getElemStringValue());
                break;
            }
            case "specsExecutionDate": {
                specsState.setSpecsExecutionDate(MapperUtil.parseDateElement(inputCursor.getElemStringValue()));
            }
        }
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<VcsLocationBambooSpecsState> list, @NotNull VcsLocationBambooSpecsState object, long objectIndex, @NotNull Session session) throws Exception {
        super.afterImportListItem(inputCursor, list, object, objectIndex, session);
        session.replicate((Object)object, ReplicationMode.OVERWRITE);
    }
}

