/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream.crowd;

import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.stream.crowd.CrowdEntityXmlMapper;
import com.atlassian.crowd.dao.alias.AliasDAOHibernate;
import com.atlassian.crowd.dao.application.ApplicationDAOHibernate;
import com.atlassian.crowd.model.alias.Alias;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationImpl;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.ReplicationMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ListMapper(rootNodeName="aliases", itemNodeName="alias")
public class AliasMapper
extends CrowdEntityXmlMapper<Alias, Alias>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(AliasMapper.class);
    private final AliasDAOHibernate aliasDAO;
    private final ApplicationDAOHibernate applicationDAO;
    protected static final String ALIAS_XML_ROOT = "aliases";
    protected static final String ALIAS_XML_NODE = "alias";
    protected static final String ALIAS_APPLICATION_ID = "applicationId";
    protected static final String ALIAS_USERNAME = "username";
    protected static final String ALIAS_ALIASNAME = "aliasname";
    private static Constructor<Alias> aliasConstructor;
    private static Method setId;
    private static Method setName;
    private static Method setApplication;

    public AliasMapper(SessionFactory sessionFactory, TransactionOperations ops, AliasDAOHibernate aliasDAO, ApplicationDAOHibernate applicationDAO) {
        super(sessionFactory, ops);
        this.aliasDAO = aliasDAO;
        this.applicationDAO = applicationDAO;
    }

    @Override
    @NotNull
    protected Alias createItemInstance(SMInputCursor inputCursor) throws Exception {
        return aliasConstructor.newInstance(new Object[0]);
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        this.exportListXml(outputElement, this.aliasDAO.findAll(), exportDetailsBean);
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull Alias alias, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, alias, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).append("id", alias.getId()).append(ALIAS_APPLICATION_ID, alias.getId()).append(ALIAS_USERNAME, alias.getName()).append(ALIAS_ALIASNAME, alias.getAlias());
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        this.importListXml(inputCursor);
    }

    @Override
    protected void importProperties(@NotNull Alias object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(object, inputCursor, session);
        switch (inputCursor.getLocalName()) {
            case "id": {
                setId.invoke((Object)object, inputCursor.getElemLongValue());
                break;
            }
            case "applicationId": {
                ApplicationImpl application = (ApplicationImpl)this.applicationDAO.loadReference(inputCursor.getElemLongValue());
                setApplication.invoke((Object)object, application);
                break;
            }
            case "username": {
                setName.invoke((Object)object, inputCursor.getElemStringValue());
                break;
            }
            case "aliasname": {
                object.setAlias(inputCursor.getElemStringValue());
            }
        }
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<Alias> list, @NotNull Alias object, long objectIndex, @NotNull Session session) throws Exception {
        session.replicate((Object)object, ReplicationMode.OVERWRITE);
    }

    static {
        try {
            aliasConstructor = Alias.class.getDeclaredConstructor(new Class[0]);
            aliasConstructor.setAccessible(true);
            setId = Alias.class.getDeclaredMethod("setId", Long.class);
            setId.setAccessible(true);
            setName = Alias.class.getDeclaredMethod("setName", String.class);
            setName.setAccessible(true);
            setApplication = Alias.class.getDeclaredMethod("setApplication", Application.class);
            setApplication.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception initialising Crowd mapper. Incompatible class change", e);
        }
    }
}

