/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream.crowd;

import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.stream.crowd.CrowdEntityXmlMapper;
import com.atlassian.bamboo.migration.stream.crowd.DirectoryMapper;
import com.atlassian.crowd.dao.application.ApplicationDefaultGroupMembershipConfigurationDaoHibernate;
import com.atlassian.crowd.embedded.api.Attributes;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationDirectoryMapping;
import com.atlassian.crowd.model.application.ApplicationImpl;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.application.GroupMapping;
import com.atlassian.crowd.model.application.InternalApplicationDefaultGroupMembershipConfiguration;
import com.atlassian.crowd.model.application.RemoteAddress;
import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.ReplicationMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ListMapper(rootNodeName="applications", itemNodeName="application")
public class ApplicationMapper
extends CrowdEntityXmlMapper<Application, ApplicationImpl>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(ApplicationMapper.class);
    public static final String APPLICATION_XML_ROOT = "applications";
    public static final String APPLICATION_XML_NODE = "application";
    public static final String APPLICATION_XML_TYPE = "type";
    public static final String APPLICATION_XML_DESCRIPTION = "description";
    public static final String APPLICATION_XML_CREDENTIAL = "credential";
    public static final String APPLICATION_XML_REMOTE_ADDRESSES = "remoteAddresses";
    public static final String APPLICATION_XML_REMOTE_ADDRESS = "remoteAddress";
    public static final String APPLICATION_XML_DIRECTORY_MAPPINGS = "directoryMappings";
    public static final String APPLICATION_XML_DIRECTORY_MAPPING = "directoryMapping";
    public static final String APPLICATION_XML_AUTO_GROUP_ADD_CONFIGS = "defaultGroupMembershipConfigs";
    public static final String APPLICATION_XML_AUTO_GROUP_ADD_CONFIG = "defaultGroupMembershipConfig";
    public static final String APPLICATION_XML_DIRECTORY_ID = "directoryId";
    public static final String APPLICATION_XML_DIRECTORY_ALLOW_ALL = "allowAll";
    public static final String APPLICATION_XML_PERMISSIONS = "permissions";
    public static final String APPLICATION_XML_PERMISSION = "permission";
    public static final String APPLICATION_XML_GROUP_MAPPINGS = "groupMappings";
    public static final String APPLICATION_XML_GROUP_MAPPING = "groupMapping";
    public static final String APPLICATION_XML_GROUP_NAME = "groupName";
    private final ApplicationManager applicationManager;
    private final DirectoryDao directoryDAO;
    private ApplicationDefaultGroupMembershipConfigurationDaoHibernate defaultGroupMembershipsDao;
    private List<InternalApplicationDefaultGroupMembershipConfiguration> defaultGroupMemberships;
    private static Constructor<ApplicationImpl> applicationConstructor;
    private static Method setDirectoryMappings;

    public ApplicationMapper(SessionFactory sessionFactory, TransactionOperations ops, ApplicationManager applicationManager, DirectoryDao directoryDAO, ApplicationDefaultGroupMembershipConfigurationDaoHibernate defaultGroupMembershipsDao) {
        super(sessionFactory, ops);
        this.applicationManager = applicationManager;
        this.directoryDAO = directoryDAO;
        this.defaultGroupMembershipsDao = defaultGroupMembershipsDao;
    }

    @Override
    @NotNull
    protected ApplicationImpl createItemInstance(SMInputCursor inputCursor) throws Exception {
        return applicationConstructor.newInstance(new Object[0]);
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        this.exportListXml(outputElement, this.applicationManager.findAll(), exportDetailsBean);
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull Application application, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, application, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).append(APPLICATION_XML_TYPE, (Enum)application.getType()).appendIfNotBlank(APPLICATION_XML_DESCRIPTION, application.getDescription()).append(APPLICATION_XML_CREDENTIAL, application.getCredential().getCredential());
        new RemoteAddressesMapper(this.getSessionFactory(), this.transactionOperations).exportListXml(session, outputElement, application.getRemoteAddresses(), exportDetailsBean);
        this.exportSingleValuedAttributes((Attributes)application, outputElement, exportDetailsBean);
        new DirectoryMappingsMapper(this.getSessionFactory(), this.transactionOperations, application, this.directoryDAO, this.defaultGroupMembershipsDao, this.defaultGroupMemberships).exportListXml(session, outputElement, application.getDirectoryMappings(), exportDetailsBean);
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        this.importListXml(inputCursor);
    }

    @Override
    protected void importProperties(@NotNull ApplicationImpl object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(object, inputCursor, session);
        switch (inputCursor.getLocalName()) {
            case "type": {
                object.setType(ApplicationType.valueOf((String)inputCursor.getElemStringValue()));
                break;
            }
            case "description": {
                object.setDescription(inputCursor.getElemStringValue());
                break;
            }
            case "credential": {
                object.setCredential(new PasswordCredential(inputCursor.getElemStringValue(), true));
                break;
            }
            case "attributes": {
                object.setAttributes(new CrowdEntityXmlMapper.SingleValuedAttributesMapper(this.getSessionFactory(), this.transactionOperations).importMapXml(inputCursor));
                break;
            }
            case "remoteAddresses": {
                object.setRemoteAddresses(new HashSet(new RemoteAddressesMapper(this.getSessionFactory(), this.transactionOperations).importListXml(inputCursor)));
                break;
            }
            case "directoryMappings": {
                setDirectoryMappings.invoke((Object)object, new DirectoryMappingsMapper(this.getSessionFactory(), this.transactionOperations, (Application)object, this.directoryDAO, this.defaultGroupMembershipsDao, this.defaultGroupMemberships).importListXml(inputCursor));
            }
        }
    }

    @Override
    public void beforeImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<ApplicationImpl> list, @NotNull Session session) throws Exception {
        super.beforeImportListItem(inputCursor, list, session);
        this.defaultGroupMemberships = new ArrayList<InternalApplicationDefaultGroupMembershipConfiguration>();
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<ApplicationImpl> list, @NotNull ApplicationImpl object, long objectIndex, @NotNull Session session) throws Exception {
        session.replicate((Object)object, ReplicationMode.OVERWRITE);
        for (InternalApplicationDefaultGroupMembershipConfiguration defaultGroupMembership : this.defaultGroupMemberships) {
            session.replicate((Object)defaultGroupMembership, ReplicationMode.OVERWRITE);
        }
    }

    static {
        try {
            applicationConstructor = ApplicationImpl.class.getDeclaredConstructor(new Class[0]);
            applicationConstructor.setAccessible(true);
            setDirectoryMappings = ApplicationImpl.class.getDeclaredMethod("setDirectoryMappings", List.class);
            setDirectoryMappings.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Exception initialising Crowd mapper. Incompatible class change", e);
        }
    }

    @ListMapper(rootNodeName="remoteAddresses", itemNodeName="remoteAddress")
    private static class RemoteAddressesMapper
    extends BambooStAXMappingListHelperAbstractImpl<RemoteAddress, RemoteAddress> {
        public RemoteAddressesMapper(SessionFactory sessionFactory, TransactionOperations transactionOperations) {
            super(sessionFactory, transactionOperations);
        }

        @Override
        @NotNull
        protected RemoteAddress createItemInstance(SMInputCursor inputCursor) throws Exception {
            return new RemoteAddress(inputCursor.getElemStringValue());
        }

        @Override
        protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull RemoteAddress object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
            outputElement.addCharacters(object.getAddress());
        }
    }

    @ListMapper(rootNodeName="directoryMappings", itemNodeName="directoryMapping")
    @VisibleForTesting
    protected static class DirectoryMappingsMapper
    extends BambooStAXMappingListHelperAbstractImpl<DirectoryMapping, DirectoryMapping> {
        private final Application application;
        private final DirectoryDao directoryDAO;
        private final ApplicationDefaultGroupMembershipConfigurationDaoHibernate defaultGroupMembershipsDao;
        private final List<InternalApplicationDefaultGroupMembershipConfiguration> defaultGroupMemberships;
        private static Constructor<DirectoryMapping> constructor;
        private static Method setApplication;
        private static Method setId;
        private static Method setDirectory;

        public DirectoryMappingsMapper(SessionFactory sessionFactory, TransactionOperations transactionOperations, Application application, DirectoryDao directoryDAO, ApplicationDefaultGroupMembershipConfigurationDaoHibernate defaultGroupMembershipsDao, List<InternalApplicationDefaultGroupMembershipConfiguration> defaultGroupMemberships) {
            super(sessionFactory, transactionOperations);
            this.application = application;
            this.directoryDAO = directoryDAO;
            this.defaultGroupMembershipsDao = defaultGroupMembershipsDao;
            this.defaultGroupMemberships = defaultGroupMemberships;
        }

        @Override
        @NotNull
        protected DirectoryMapping createItemInstance(SMInputCursor inputCursor) throws Exception {
            return constructor.newInstance(new Object[0]);
        }

        @Override
        protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull DirectoryMapping directoryMapping, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
            super.exportProperties(outputElement, directoryMapping, session, exportDetailsBean);
            new SMOutputElementAppender(outputElement).append("id", directoryMapping.getId()).append(ApplicationMapper.APPLICATION_XML_DIRECTORY_ID, directoryMapping.getDirectory().getId()).append(ApplicationMapper.APPLICATION_XML_DIRECTORY_ALLOW_ALL, directoryMapping.isAllowAllToAuthenticate());
            TreeSet groupMappings = new TreeSet(new GroupMapping.COMPARATOR());
            groupMappings.addAll(directoryMapping.getAuthorisedGroups());
            new GroupMappingsMapper(this.getSessionFactory(), this.transactionOperations, directoryMapping).exportListXml(outputElement, groupMappings, exportDetailsBean);
            new DirectoryMapper.PermissionsMapper(this.getSessionFactory(), this.transactionOperations).exportListXml(outputElement, directoryMapping.getAllowedOperations(), exportDetailsBean);
            new GroupMembershipMapper(this.getSessionFactory(), this.transactionOperations, directoryMapping).exportListXml(outputElement, this.defaultGroupMembershipsDao.listAll(this.application, (ApplicationDirectoryMapping)directoryMapping), exportDetailsBean);
        }

        @Override
        protected void importProperties(@NotNull DirectoryMapping object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
            super.importProperties(object, inputCursor, session);
            if (object.getApplication() == null) {
                setApplication.invoke((Object)object, this.application);
            }
            switch (inputCursor.getLocalName()) {
                case "id": {
                    setId.invoke((Object)object, inputCursor.getElemLongValue());
                    break;
                }
                case "directoryId": {
                    Directory directoryReference = this.directoryDAO.findById(inputCursor.getElemLongValue());
                    setDirectory.invoke((Object)object, directoryReference);
                    break;
                }
                case "allowAll": {
                    object.setAllowAllToAuthenticate(inputCursor.getElemBooleanValue());
                    break;
                }
                case "groupMappings": {
                    object.setAuthorisedGroups(new HashSet(new GroupMappingsMapper(this.getSessionFactory(), this.transactionOperations, object).importListXml(inputCursor)));
                    break;
                }
                case "permissions": {
                    object.setAllowedOperations(new HashSet(new DirectoryMapper.PermissionsMapper(this.getSessionFactory(), this.transactionOperations).importListXml(inputCursor)));
                    break;
                }
                case "defaultGroupMembershipConfigs": {
                    this.defaultGroupMemberships.addAll(new GroupMembershipMapper(this.getSessionFactory(), this.transactionOperations, object).importListXml(inputCursor));
                }
            }
        }

        static {
            try {
                constructor = DirectoryMapping.class.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                setApplication = DirectoryMapping.class.getDeclaredMethod("setApplication", Application.class);
                setApplication.setAccessible(true);
                setId = DirectoryMapping.class.getDeclaredMethod("setId", Long.class);
                setId.setAccessible(true);
                setDirectory = DirectoryMapping.class.getDeclaredMethod("setDirectory", Directory.class);
                setDirectory.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Exception initialising Crowd mapper. Incompatible class change", e);
            }
        }
    }

    @ListMapper(rootNodeName="groupMappings", itemNodeName="groupMapping")
    @VisibleForTesting
    protected static class GroupMappingsMapper
    extends BambooStAXMappingListHelperAbstractImpl<GroupMapping, GroupMapping> {
        private static Constructor<GroupMapping> constructor;
        private final DirectoryMapping directoryMapping;

        public GroupMappingsMapper(SessionFactory sessionFactory, TransactionOperations transactionOperations, DirectoryMapping directoryMapping) {
            super(sessionFactory, transactionOperations);
            this.directoryMapping = directoryMapping;
        }

        @Override
        @NotNull
        protected GroupMapping createItemInstance(SMInputCursor inputCursor) throws Exception {
            return constructor.newInstance(new Object[0]);
        }

        @Override
        protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull GroupMapping groupMapping, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
            super.exportProperties(outputElement, groupMapping, session, exportDetailsBean);
            new SMOutputElementAppender(outputElement).append("id", groupMapping.getId()).append(ApplicationMapper.APPLICATION_XML_GROUP_NAME, groupMapping.getGroupName());
        }

        @Override
        protected void importProperties(@NotNull GroupMapping object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
            super.importProperties(object, inputCursor, session);
            switch (inputCursor.getLocalName()) {
                case "id": {
                    object.setId(Long.valueOf(inputCursor.getElemLongValue()));
                    break;
                }
                case "groupName": {
                    object.setGroupName(inputCursor.getElemStringValue());
                }
            }
        }

        @Override
        public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<GroupMapping> list, @NotNull GroupMapping object, long objectIndex, @NotNull Session session) throws Exception {
            object.setDirectoryMapping(this.directoryMapping);
            object.setApplication(this.directoryMapping.getApplication());
        }

        static {
            try {
                constructor = GroupMapping.class.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Exception initialising Crowd mapper. Incompatible class change", e);
            }
        }
    }

    @ListMapper(rootNodeName="defaultGroupMembershipConfigs", itemNodeName="defaultGroupMembershipConfig")
    private static class GroupMembershipMapper
    extends BambooStAXMappingListHelperAbstractImpl<InternalApplicationDefaultGroupMembershipConfiguration, InternalApplicationDefaultGroupMembershipConfiguration> {
        private final DirectoryMapping directoryMapping;

        public GroupMembershipMapper(SessionFactory sessionFactory, TransactionOperations transactionOperations, DirectoryMapping directoryMapping) {
            super(sessionFactory, transactionOperations);
            this.directoryMapping = directoryMapping;
        }

        @Override
        @NotNull
        protected InternalApplicationDefaultGroupMembershipConfiguration createItemInstance(SMInputCursor inputCursor) throws Exception {
            return new InternalApplicationDefaultGroupMembershipConfiguration();
        }

        @Override
        protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull InternalApplicationDefaultGroupMembershipConfiguration defaultGroupMembership, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
            super.exportProperties(outputElement, defaultGroupMembership, session, exportDetailsBean);
            new SMOutputElementAppender(outputElement).append("id", defaultGroupMembership.getId()).append(ApplicationMapper.APPLICATION_XML_GROUP_NAME, defaultGroupMembership.getGroupName());
        }

        @Override
        protected void importProperties(@NotNull InternalApplicationDefaultGroupMembershipConfiguration object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
            super.importProperties(object, inputCursor, session);
            switch (inputCursor.getLocalName()) {
                case "id": {
                    object.setId(Long.valueOf(inputCursor.getElemLongValue()));
                    break;
                }
                case "groupName": {
                    object.setGroupName(inputCursor.getElemStringValue());
                }
            }
        }

        @Override
        public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<InternalApplicationDefaultGroupMembershipConfiguration> list, @NotNull InternalApplicationDefaultGroupMembershipConfiguration object, long objectIndex, @NotNull Session session) throws Exception {
            object.setDirectoryMapping(this.directoryMapping);
        }
    }
}

