/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream.crowd;

import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.MapperUtil;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.crowd.embedded.api.Attributes;
import com.atlassian.crowd.model.InternalEntity;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

public abstract class CrowdEntityXmlMapper<T, I extends T>
extends BambooStAXMappingListHelperAbstractImpl<T, I> {
    public static final String GENERIC_XML_ID = "id";
    public static final String GENERIC_XML_NAME = "name";
    public static final String GENERIC_XML_CREATED_DATE = "createdDate";
    public static final String GENERIC_XML_UPDATED_DATE = "updatedDate";
    public static final String GENERIC_XML_ACTIVE = "active";
    public static final String GENERIC_XML_ATTRIBUTES = "attributes";
    public static final String GENERIC_XML_ATTRIBUTE = "attribute";
    public static final String GENERIC_XML_ATTRIBUTE_NAME = "name";
    public static final String GENERIC_XML_ATTRIBUTE_VALUE = "value";
    protected static Method setId;
    protected static Method setName;
    protected static Method setActive;

    public CrowdEntityXmlMapper(SessionFactory sessionFactory, TransactionOperations ops) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_TRANSACTION, ops);
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull T entity, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        InternalEntity internalEntity = (InternalEntity)Narrow.downTo(entity, InternalEntity.class);
        if (internalEntity != null) {
            new SMOutputElementAppender(outputElement).append(GENERIC_XML_ID, internalEntity.getId()).append("name", internalEntity.getName()).appendIfNotNull(GENERIC_XML_CREATED_DATE, internalEntity.getCreatedDate()).appendIfNotNull(GENERIC_XML_UPDATED_DATE, internalEntity.getUpdatedDate()).append(GENERIC_XML_ACTIVE, internalEntity.isActive());
        }
    }

    @Override
    protected void importProperties(@NotNull I object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        InternalEntity internalEntity = (InternalEntity)Narrow.downTo(object, InternalEntity.class);
        if (internalEntity != null) {
            String elementLocalName = inputCursor.getLocalName();
            if (GENERIC_XML_ID.equals(elementLocalName)) {
                setId.invoke((Object)internalEntity, inputCursor.getElemLongValue());
            } else if ("name".equals(elementLocalName)) {
                setName.invoke((Object)internalEntity, inputCursor.getElemStringValue());
            } else if (GENERIC_XML_CREATED_DATE.equals(elementLocalName)) {
                internalEntity.setCreatedDate(MapperUtil.parseDateElement(inputCursor.getElemStringValue()));
            } else if (GENERIC_XML_UPDATED_DATE.equals(elementLocalName)) {
                internalEntity.setUpdatedDate(MapperUtil.parseDateElement(inputCursor.getElemStringValue()));
            } else if (GENERIC_XML_ACTIVE.equals(elementLocalName)) {
                setActive.invoke((Object)internalEntity, inputCursor.getElemBooleanValue());
            }
        }
    }

    protected void exportSingleValuedAttributes(Attributes entity, SMOutputElement element, ExportDetailsBean exportDetailsBean) throws Exception {
        TreeSet attributeSet = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        attributeSet.addAll(entity.getKeys());
        List attributes = attributeSet.stream().map(k -> new Attribute((String)k, entity.getValue(k))).filter(a -> a.getName() != null && a.getValue() != null).collect(Collectors.toList());
        new SingleValuedAttributesMapper(this.getSessionFactory(), this.transactionOperations).exportListXml(this.getSession(), element, attributes, exportDetailsBean);
    }

    static {
        try {
            setId = InternalEntity.class.getDeclaredMethod("setId", Long.class);
            setId.setAccessible(true);
            setName = InternalEntity.class.getDeclaredMethod("setName", String.class);
            setName.setAccessible(true);
            setActive = InternalEntity.class.getDeclaredMethod("setActive", Boolean.TYPE);
            setActive.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Exception initialising Crowd mapper. Incompatible class change", e);
        }
    }

    @ListMapper(rootNodeName="attributes", itemNodeName="attribute")
    protected static class SingleValuedAttributesMapper
    extends BambooStAXMappingListHelperAbstractImpl<Attribute, Attribute> {
        protected SingleValuedAttributesMapper(SessionFactory sessionFactory, @NotNull TransactionOperations transactionOperations) {
            super(sessionFactory, transactionOperations);
        }

        @Override
        @NotNull
        protected Attribute createItemInstance(SMInputCursor inputCursor) throws Exception {
            return new Attribute();
        }

        @Override
        protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull Attribute object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
            new SMOutputElementAppender(outputElement).append("name", object.getName()).append(CrowdEntityXmlMapper.GENERIC_XML_ATTRIBUTE_VALUE, object.getValue());
        }

        @Override
        protected void importProperties(@NotNull Attribute entry, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
            String elementName;
            switch (elementName = inputCursor.getLocalName()) {
                case "name": {
                    entry.setName(inputCursor.getElemStringValue());
                    break;
                }
                case "value": {
                    entry.setValue(inputCursor.getElemStringValue());
                }
            }
        }

        public Map<String, String> importMapXml(@NotNull SMInputCursor inputCursor) throws Exception {
            HashMap<String, String> map = new HashMap<String, String>();
            for (Attribute attribute : this.importListXml(inputCursor)) {
                map.put(attribute.getName(), attribute.getValue());
            }
            return map;
        }
    }

    private static class Attribute {
        private String name;
        private String value;

        public Attribute() {
        }

        public Attribute(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

