/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream.crowd;

import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.stream.build.SpecsStateMapper;
import com.atlassian.bamboo.migration.stream.crowd.CrowdEntityXmlMapper;
import com.atlassian.crowd.embedded.api.Attributes;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.search.query.DirectoryQueries;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.ReplicationMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ListMapper(rootNodeName="directories", itemNodeName="directory")
public class DirectoryMapper
extends CrowdEntityXmlMapper<Directory, DirectoryImpl>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(SpecsStateMapper.class);
    private final DirectoryDao crowdDirectoryHibernateDao;
    protected static final String DIRECTORY_XML_ROOT = "directories";
    protected static final String DIRECTORY_XML_NODE = "directory";
    private static final String DIRECTORY_XML_DESCRIPTION = "description";
    private static final String DIRECTORY_XML_TYPE = "type";
    private static final String DIRECTORY_XML_IMPLEMENTATION_CLASS = "implementationClass";
    private static final String DIRECTORY_XML_PERMISSIONS = "permissions";
    private static final String DIRECTORY_XML_PERMISSION = "permission";

    public DirectoryMapper(SessionFactory sessionFactory, TransactionOperations ops, DirectoryDao crowdDirectoryHibernateDao) {
        super(sessionFactory, ops);
        this.crowdDirectoryHibernateDao = crowdDirectoryHibernateDao;
    }

    @Override
    @NotNull
    protected DirectoryImpl createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new DirectoryImpl();
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        this.exportListXml(outputElement, this.crowdDirectoryHibernateDao.search(DirectoryQueries.allDirectories()), exportDetailsBean);
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull Directory directoryParam, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        DirectoryImpl directory = new DirectoryImpl(directoryParam);
        super.exportProperties(outputElement, directory, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).appendIfNotBlank(DIRECTORY_XML_DESCRIPTION, directory.getDescription()).append(DIRECTORY_XML_TYPE, (Enum)directory.getType()).append(DIRECTORY_XML_IMPLEMENTATION_CLASS, directory.getImplementationClass());
        SMOutputElement permissionsElement = outputElement.addElement(DIRECTORY_XML_PERMISSIONS);
        TreeSet operations = Sets.newTreeSet((Iterable)directory.getAllowedOperations());
        new PermissionsMapper(this.getSessionFactory(), this.transactionOperations).exportListXml(session, outputElement, operations, exportDetailsBean);
        this.exportSingleValuedAttributes((Attributes)directory, outputElement, exportDetailsBean);
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        super.importListXml(inputCursor);
    }

    @Override
    protected void importProperties(@NotNull DirectoryImpl object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(object, inputCursor, session);
        String elementLocalName = inputCursor.getLocalName();
        if (DIRECTORY_XML_DESCRIPTION.equals(elementLocalName)) {
            object.setDescription(inputCursor.getElemStringValue());
        } else if (DIRECTORY_XML_TYPE.equals(elementLocalName)) {
            object.setType(DirectoryType.valueOf((String)inputCursor.getElemStringValue()));
        } else if (DIRECTORY_XML_IMPLEMENTATION_CLASS.equals(elementLocalName)) {
            object.setImplementationClass(inputCursor.getElemStringValue());
        } else if (DIRECTORY_XML_PERMISSIONS.equals(elementLocalName)) {
            new PermissionsMapper(this.getSessionFactory(), this.transactionOperations).importListXml(inputCursor).forEach(arg_0 -> ((DirectoryImpl)object).addAllowedOperation(arg_0));
        } else if ("attributes".equals(elementLocalName)) {
            object.setAttributes(new CrowdEntityXmlMapper.SingleValuedAttributesMapper(this.getSessionFactory(), this.transactionOperations).importMapXml(inputCursor));
        }
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<DirectoryImpl> list, @NotNull DirectoryImpl object, long objectIndex, @NotNull Session session) throws Exception {
        session.replicate((Object)object, ReplicationMode.OVERWRITE);
    }

    @ListMapper(rootNodeName="permissions", itemNodeName="permission")
    public static class PermissionsMapper
    extends BambooStAXMappingListHelperAbstractImpl<OperationType, OperationType> {
        public PermissionsMapper(SessionFactory sessionFactory, TransactionOperations transactionOperations) {
            super(sessionFactory, transactionOperations);
        }

        @Override
        @NotNull
        protected OperationType createItemInstance(SMInputCursor inputCursor) throws Exception {
            return OperationType.valueOf((String)inputCursor.getElemStringValue());
        }

        @Override
        protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull OperationType object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
            outputElement.addCharacters(object.name());
        }
    }
}

