/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream.crowd;

import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.stream.crowd.PartialCrowdEntityXmlMapper;
import com.atlassian.crowd.dao.group.GroupDAOHibernate;
import com.atlassian.crowd.dao.group.InternalGroupDao;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.InternalDirectoryEntity;
import com.atlassian.crowd.model.InternalEntityAttribute;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.InternalGroup;
import com.atlassian.crowd.model.group.InternalGroupAttribute;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.ReplicationMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ListMapper(rootNodeName="crowdGroups", itemNodeName="group")
public class GroupMapper
extends PartialCrowdEntityXmlMapper<InternalGroup, InternalGroup>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(GroupMapper.class);
    private final InternalGroupDao groupDao;
    private final DirectoryDao directoryDao;
    private static final Set<DirectoryType> INCLUDED_DIRECTORY_TYPES = EnumSet.of(DirectoryType.INTERNAL, DirectoryType.DELEGATING, DirectoryType.CONNECTOR);
    protected static final String GROUP_XML_ROOT = "crowdGroups";
    private static final String GROUP_XML_NODE = "group";
    private static final String GROUP_XML_DIRECTORY_ID = "directoryId";
    private static final String GROUP_XML_DESCRIPTION = "description";
    private static final String GROUP_XML_TYPE = "type";
    private static final String GROUP_XML_ATTRIBUTES = "attributes";
    private static final String GROUP_XML_ATTRIBUTE = "attribute";
    private static final String GROUP_XML_ATTRIBUTE_NAME = "name";
    private static final String GROUP_XML_ATTRIBUTE_VALUE = "value";
    public static final String REMOTE_GROUP_XML_ROOT = "groups";
    public static final String REMOTE_GROUP_XML_NODE = "group";
    public static final String REMOTE_GROUP_XML_PRINCIPAL_NAME = "name";
    public static final String REMOTE_GROUP_XML_NAME = "name";
    public static final String REMOTE_GROUP_XML_PRINCIPAL_DIRECTORY_ID = "directoryId";
    public static final String REMOTE_GROUP_XML_DIRECTORY_ID = "directoryId";
    public static final String REMOTE_GROUP_XML_ACTIVE = "active";
    public static final String REMOTE_GROUP_XML_DESCRIPTION = "description";
    public static final String REMOTE_GROUP_XML_PRINCIPAL_NODE = "principals";
    public static final String REMOTE_GROUP_XML_PRINCIPAL = "principal";
    private static Constructor<InternalGroup> internalGroupConstructor;
    private static Method setDirectory;
    private static Method setType;
    private static Method setDescription;
    private static Method setAttributes;

    public GroupMapper(SessionFactory sessionFactory, TransactionOperations ops, DirectoryManager directoryManager, DirectoryDao directoryDao, GroupDAOHibernate groupDao) {
        super(sessionFactory, ops, directoryManager, INCLUDED_DIRECTORY_TYPES);
        this.groupDao = groupDao;
        this.directoryDao = directoryDao;
    }

    @Override
    @NotNull
    protected InternalGroup createItemInstance(SMInputCursor inputCursor) throws Exception {
        return internalGroupConstructor.newInstance(new Object[0]);
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        SMOutputElement rootElement = this.createListRootElement(outputElement);
        List<Directory> directories = this.findAllExportableDirectories();
        for (Directory directory : directories) {
            for (InternalGroup group : this.findExportableGroups(directory)) {
                this.exportXml(rootElement, group, exportDetailsBean);
            }
        }
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull InternalGroup group, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, group, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).append("directoryId", group.getDirectoryId()).appendIfNotBlank("description", group.getDescription()).append(GROUP_XML_TYPE, (Enum)group.getType());
        new GroupAttributeMapper(this.getSessionFactory(), this.transactionOperations, group).exportListXml(session, outputElement, this.groupDao.findGroupAttributes(group.getId().longValue()), exportDetailsBean);
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        this.importListXml(inputCursor);
    }

    @Override
    protected void importProperties(@NotNull InternalGroup object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(object, inputCursor, session);
        switch (inputCursor.getLocalName()) {
            case "directoryId": {
                Directory directory = this.directoryDao.findById(inputCursor.getElemLongValue());
                setDirectory.invoke((Object)object, directory);
                break;
            }
            case "type": {
                setType.invoke((Object)object, GroupType.valueOf((String)inputCursor.getElemStringValue()));
                break;
            }
            case "description": {
                setDescription.invoke((Object)object, inputCursor.getElemStringValue());
                break;
            }
            case "attributes": {
                setAttributes.invoke((Object)object, new HashSet(new GroupAttributeMapper(this.getSessionFactory(), this.transactionOperations, object).importListXml(inputCursor)));
            }
        }
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<InternalGroup> list, @NotNull InternalGroup object, long objectIndex, @NotNull Session session) throws Exception {
        object.setLocal(true);
        session.replicate((Object)object, ReplicationMode.OVERWRITE);
        for (InternalGroupAttribute groupAttribute : object.getAttributes()) {
            session.replicate((Object)groupAttribute, ReplicationMode.OVERWRITE);
        }
    }

    private List<InternalGroup> findExportableGroups(Directory directory) {
        QueryBuilder.PartialEntityQuery partialQuery = QueryBuilder.queryFor(InternalGroup.class, (EntityDescriptor)EntityDescriptor.group());
        EntityQuery query = this.isExportOfNonLocalGroupsRequired(directory.getType()) ? partialQuery.returningAtMost(-1) : partialQuery.with((SearchRestriction)Restriction.on((Property)GroupTermKeys.LOCAL).exactlyMatching((Object)true)).returningAtMost(-1);
        return this.groupDao.search(directory.getId().longValue(), query);
    }

    static {
        try {
            internalGroupConstructor = InternalGroup.class.getDeclaredConstructor(new Class[0]);
            internalGroupConstructor.setAccessible(true);
            setDirectory = InternalDirectoryEntity.class.getDeclaredMethod("setDirectory", Directory.class);
            setDirectory.setAccessible(true);
            setType = InternalGroup.class.getDeclaredMethod("setType", GroupType.class);
            setType.setAccessible(true);
            setDescription = InternalGroup.class.getDeclaredMethod("setDescription", String.class);
            setDescription.setAccessible(true);
            setAttributes = InternalGroup.class.getDeclaredMethod("setAttributes", Set.class);
            setAttributes.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Exception initialising Crowd mapper. Incompatible class change", e);
        }
    }

    @ListMapper(rootNodeName="attributes", itemNodeName="attribute")
    protected static class GroupAttributeMapper
    extends BambooStAXMappingListHelperAbstractImpl<InternalGroupAttribute, InternalGroupAttribute> {
        private final InternalGroup group;
        private static Constructor<InternalGroupAttribute> constructor;
        private static Method setId;
        private static Method setGroup;
        private static Method setDirectory;

        protected GroupAttributeMapper(SessionFactory sessionFactory, @NotNull TransactionOperations transactionOperations, InternalGroup group) {
            super(sessionFactory, transactionOperations);
            this.group = group;
        }

        @Override
        @NotNull
        protected InternalGroupAttribute createItemInstance(SMInputCursor inputCursor) throws Exception {
            return constructor.newInstance(new Object[0]);
        }

        @Override
        protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull InternalGroupAttribute attribute, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
            new SMOutputElementAppender(outputElement).append("id", attribute.getId()).append("name", attribute.getName()).append(GroupMapper.GROUP_XML_ATTRIBUTE_VALUE, attribute.getValue());
        }

        @Override
        protected void importProperties(@NotNull InternalGroupAttribute entry, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
            String elementName;
            switch (elementName = inputCursor.getLocalName()) {
                case "id": {
                    setId.invoke((Object)entry, inputCursor.getElemLongValue());
                    break;
                }
                case "name": {
                    entry.setName(inputCursor.getElemStringValue());
                    break;
                }
                case "value": {
                    entry.setValue(inputCursor.getElemStringValue());
                }
            }
        }

        @Override
        public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<InternalGroupAttribute> list, @NotNull InternalGroupAttribute object, long objectIndex, @NotNull Session session) throws Exception {
            setGroup.invoke((Object)object, this.group);
            setDirectory.invoke((Object)object, this.group.getDirectory());
        }

        static {
            try {
                constructor = InternalGroupAttribute.class.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                setId = InternalEntityAttribute.class.getDeclaredMethod("setId", Long.class);
                setId.setAccessible(true);
                setGroup = InternalGroupAttribute.class.getDeclaredMethod("setGroup", InternalGroup.class);
                setGroup.setAccessible(true);
                setDirectory = InternalGroupAttribute.class.getDeclaredMethod("setDirectory", Directory.class);
                setDirectory.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Exception initialising Crowd mapper. Incompatible class change", e);
            }
        }
    }
}

